########################## Hypotheses Testing ###########################

################################################# set 'working Directory'
setwd("D:/AS17 translation/hypothesentest/rcode")
opar <- par() 
#options(warn=-1)
#########################################################################
#                            Sources
#########################################################################
#       sweat.csv
# repeated-01.csv
#   bland_cor.csv
#########################################################################

                                                          # Section 7.1.5

r <- 1:5                   # how often is a true null hypothesis rejected
p <- 0.01
n <- c(22, 83, 154, 231, 310)
P <- round(pnbinom(n-r, r, p), 2); P

#########################################################################

                                                          # Section 7.1.6
                                                        
alpha <- 0.05                             # one sample Gauss test (model)
mu.0  <- 20
sigma <- 10
n     <- 25

l.a    <- mu.0 - qnorm(1-alpha, mean=0, sd=1)*(sigma/sqrt(n)); l.a
l.b    <- mu.0 + qnorm(1-alpha, mean=0, sd=1)*(sigma/sqrt(n)); l.b
l.c1   <- mu.0 - qnorm(1-alpha/2, mean=0, sd=1)*(sigma/sqrt(n)); l.c1
l.c2   <- mu.0 + qnorm(1-alpha/2, mean=0, sd=1)*(sigma/sqrt(n)); l.c2

m      <- 16
p.a    <- pnorm(m, mean=mu.0, sd=sigma/sqrt(n)); p.a 
p.b    <- 1 - pnorm(m, mean=mu.0, sd=sigma/sqrt(n)); p.b 
p.c    <- 2 * pnorm(m, mean=mu.0, sd=sigma/sqrt(n)); p.c

#########################################################################

                                                          # Section 7.1.7
                                                        
alpha <- 0.05                                            # power function
nro1  <- 10; nro2 <- 20;
diff  <- seq(-4, +4, by=0.01)
stdev <- 2

result1 <- power.t.test(n = nro1, delta = diff, sd = stdev, 
    sig.level = alpha, type = "one.sample", alternative = "two.sided")
result2 <- power.t.test(n = nro2, delta = diff, sd = stdev, 
    sig.level = alpha, type = "one.sample", alternative = "two.sided")
    
                                                             # figure 7.2 
par(mfcol=c(1,1), lwd=2, font.axis=2, bty="l", ps=15)  
plot(diff/stdev, result1$power, type = "l", xlim=c(-1.6, +1.6), 
        ylim=c(0,1), axes = FALSE,
     xlab = expression(paste("Difference ",mu - mu[0],
     "  in units of ",sigma[0],"  for  ",alpha," = 0.05")),
     ylab = expression(paste("Power  (1 - ",beta," )")))
axis(2, pos=c(-1.7,0),las=1)    ; axis(2, pos=c(0,0), las=1)
axis(2, pos=c(+1.7,0), las=1)   ; axis(1, pos=c(0,0))
lines(diff/stdev, result2$power); abline(v=1, lty=2)          
text(-0.4,0.7,"n = 20")
text(-0.8,0.4,"n = 10")

#########################################################################

power.t.test(n = 10, delta = 5, sd = 5, sig.level = 0.05,
                       type = "one.sample", alternative = "two.sided")
power.t.test(n = 20, delta = 5, sd = 5, sig.level = 0.05,
                       type = "one.sample", alternative = "two.sided")

#########################################################################

                                                          # Section 7.1.8

                                  # OC curves in quality control 
n <- 46                           # sample size               
c <- 1                            # acceptance number           
N <- 1000                         # scale of charge                   

                                  # probability of defect units (quality)
p <- seq(0, 0.1, by=0.005)    
P <- pbinom(c, n, p)

pbinom(1, 46, 0.0077)              #  AQL for alpha = 0.05             
pbinom(1, 46, 0.0819)              #  RQL for beta  = 0.10             

                                                             # figure 7.3
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=14)
plot(p, P, type="b", xlim=c(0, 0.1), ylim=c(0, 1), las=1,
     xlab="p - proportion of defects (quality)",
     ylab="P - probability for acceptance")

abline(h=0.1, lty=1, col="grey")
abline(h=0.95, lty=1, col="grey")

abline(v=0.0075, lty=2, col="grey")
abline(v=0.0825, lty=2, col="grey")

text(0.012, 0.99, expression(alpha), cex=1.5)
text(0.035, 0.99, "(producer's risk)")

text(0.012, 0.15, expression(beta), cex=1.5)
text(0.035, 0.15, "(consumer's risk)")

text(0.015, 0.00, "AQL = 0.0077", cex=1.2)
text(0.085, 0.00, "RQL = 0.0819", cex=1.2)

#########################################################################

                                                             # figure 7.4
AOQ <- P * p * (N-n) / N
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=15, cex.axis=1) 
plot(p, AOQ, type="b", xlim=c(0, 0.1), ylim=c(0, 0.02), las=0,
     xlab="p - proportion of defects (quality)",
     ylab="average throughput  (AOQ)")
abline(h=0.0174, lty=1)
abline(v=0.035, lty=2)
text(0.06, 0.0185, "AOQL=0.0174")

# ATI <- n + (1-P) * (N-n)    
# plot(p, ATI, type="b", xlim=c(0, 0.1), ylim=c(0, 1000), las=1,
#      xlab="p - proportion of defects",
#      ylab="average costs (ATI)")     

#########################################################################

                                                          # Section 7.2.2

                                                  # skewness and kurtosis
x <- c(rep(30, 16), 50, 70, 90, 110)              # data
n <- length(x);  m <- mean(x)
sqrt(n)*sum((x-m)^3) / sqrt(sum((x-m)^2)^3)       # skewness  
n * sum((x-m)^4) / (sum((x-m)^2))^2               # kurtosis  
library(e1071)
x <- c(rep(30, 16), 50, 70, 90, 110) 
skewness(x)                               # functions from library(e1071)
kurtosis(x)+3

#########################################################################

                                                          # symmetry test
x <- c(3, 5, 2, 6, 7, 7, 4, 2, 6, 12, 15, 18); sort(x)
n <- length(x); m <- mean(x); I <- ifelse(x<m, 1, 0)
S <- sum(I); Amin <- S; Aplus <- n - S
test <- (Amin - Aplus)^2 / n; test
qchisq(0.10, 1, lower.tail=F)

#########################################################################

                                                          # Section 7.2.3

                                              # quantile-quantile plot

                                              # BMI - data,  table 7.6
nblz <- c(90,  74,  94,  79, 100,  87,  87,  84,  78,  94,
          73,  99,  85,  83,  70,  84,  91,  99,  85,  89,  
          80,  89,  81,  95,  89,  94,  77,  87,  89,  86,  
          94, 110,  92,  92,  93,  94,  87,  90, 107,  74)
chol <- c(195, 205, 245, 190, 260, 190, 340, 195, 285, 380, 
          220, 240, 235, 215, 190, 275, 205, 290, 200, 210,
          220, 265, 235, 200, 350, 220, 450, 230, 185, 295,
          380, 200, 485, 210, 185, 210, 395, 290, 190, 210)     
                                                          
                                                             # figure 7.6
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=15)    
qqnorm(nblz, ylab="Blood sugar [mg/dl]", xlab="Normal distribution", 
       main=" ", pch=19, cex=0.9)
qqline(nblz, col = "black", lwd=2)
          
qqnorm(chol, ylab="Cholesterol [mg/dl]", xlab="Normal distribution", 
             ylim=c(150, 500), main= " ", pch=19, cex=0.9)
qqline(chol, col = "black", lwd=2)

#########################################################################

                                                          # Section 7.2.4

                                                 # Box-Cox transformation
bcplot <- function(x, lambda) {
          n <- length(lambda); v <- rep(NA, n)
          for (i in 1:n) {
              if (lambda[i] == 0) y <- log(x)
              if (lambda[i] != 0) y <- (x^lambda[i] - 1)/lambda[i]
              nppl <- qqnorm(y, plot.it = FALSE); v[i]=cor(nppl$x,nppl$y)      }
          j <- which(v == max(v))
          list("cor"=v, "l.i"=lambda, "lambda"=lambda[j])    }
                                         
x <- c(20, 22, 24, 21, 19, 30, 40, 23, 24, 25, 19)         # example data
l  <- seq(-5, +2, by=0.1);  lp <- bcplot(x, l); lp$lambda


                                                             # figure 7.8
par(mfrow=c(1,3), lwd=2, font=2, font.axis=2, bty="l", ps=17)
qqnorm(x, main="Before transformation",xlab="Q-normal",ylab="Q-data")
qqline(x)
plot(lp$l.i, lp$cor, main="Box-Cox plot", xlab="Lambda", 
            ylab="Correlation coefficient")
xtrn <- (x^lp$lambda -1)/lp$lambda
qqnorm(xtrn, main="After transformation",xlab="Q-normal", 
            ylab="Q-transf. data")
qqline(xtrn)

#########################################################################

                                                          # Section 7.2.5
                                                        
                                        # Chi-Square goodness-of-fit test
obs <- c(7, 16, 8, 17, 3, 9); summe <- sum(obs)
exp <- rep(summe/6, 6)
stat <- sum((obs-exp)^2/exp); stat; qchisq(0.95, 5)

#########################################################################

                                                             # figure 7.9
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=15)    
breaks <- seq(60, 120, by=8);  breite <- 8
hist(nblz, breaks, plot=T, col="grey", las=1,
     main=" ", xlab="Blood sugar [mg/dl]", ylab="Frequency",xlim=c(60,120))
x      <- seq(60, 120, by=2) 
lines(x, dnorm(x, mean=mean(nblz), 
              sd=sd(nblz)) * breite * length(nblz), col="black", lwd=2)

breaks <- seq(180, 500, by=40); breite <- 40
hist(chol, breaks, plot=T, col="grey", las=1,
     main=" ", xlab="Cholesterol [mg/dl]", ylab="Frequency",xlim=c(180, 500))
x      <- seq(180, 500, by=40) 
lines(x, dnorm(x, mean=mean(chol), 
              sd=sd(chol)) * breite * length(chol), col="black", lwd=2)

#########################################################################

library(nortest)
pearson.test(nblz, n.classes=8, adjust=TRUE)
pearson.test(chol, n.classes=8, adjust=TRUE)

#########################################################################

                                                          # Section 7.2.6
                                                        
                                                # Kolmogorov-Smirnov test

                                                            # figure 7.10
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=15)
n <- length(nblz)
p <- cumsum(rep(1,n)/n)
plot(sort(nblz), p, type="s", las=1,
     xlab="Blood sugar [mg/dl]", ylab="F(x)")
x <- seq(60, 120, by =2)
y <- pnorm(x, mean=mean(nblz), sd=sd(nblz), log=FALSE)
lines(x, y, col="black")

n <- length(chol)
p <- cumsum(rep(1,n)/n)
plot(sort(chol), p, type="s", las=1,
     xlab="Cholesterol [mg/dl]", ylab="F(x)")
x <- seq(180, 500, by =10)
y <- pnorm(x, mean=mean(chol), sd=sd(chol), log=FALSE)
lines(x, y, col="black")

#########################################################################

library(nortest)
ks.test(nblz, "pnorm", mean(nblz), sd(nblz))
ks.test(chol, "pnorm", mean(chol), sd(chol))

#########################################################################

library(nortest)
lillie.test(nblz)
lillie.test(chol)

#########################################################################

                                                          # Section 7.2.7
                                                        
library(nortest)                                      # Shapiro-Wilk test
shapiro.test(nblz)
shapiro.test(chol)

#########################################################################

                                                          # Section 7.2.8
                                                        
library(nortest)                                  # Anderson-Darling test
ad.test(nblz)
ad.test(chol)

#########################################################################

                                                          # Section 7.2.9
  
                                                              # Outlier ?     
# x <- round(rnorm(15, mean=5, sd=0.5), 1); x
# x <- c(2.5, x, 7.4, 8.3)

par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=15)       # figure 7.11
x <- c(3.2, 5.1, 5.0, 5.3, 5.1, 5.3, 4.8, 5.7, 4.5, 5.4,
       4.6, 4.8, 6.1, 5.5, 4.3, 4.8, 7.4, 8.3)
bp <- boxplot(x, range=1.5, col="grey", las=1, ylim=c(3,9)); bp$out
Q <- quantile(x, p=c(0.25,0.5,0.75)); Q1 <- Q[1]; Q3 <- Q[3]
cat("Limits:",Q1 - IQR(x)*1.5,"-",Q3 + IQR(x)*1.5,"\n")  

#########################################################################
                                    
                                              # test for outliers: Hampel 
x <- c(3.2, 5.1, 5.0, 5.3, 5.1, 5.3, 4.8, 5.7, 4.5, 5.4,
       4.6, 4.8, 6.1, 5.5, 4.3, 4.8, 7.4, 8.3)
med.x <- median(x);      mad.x <- mad(x, constant=1)
outlier <- (x < med.x - 5.2*mad.x) | (x > med.x + 5.2*mad.x); x[outlier]

#########################################################################

                                               # test for outlier: Grubbs
x <- c(3, 4, 4, 5, 6, 6, 7, 8, 9, 10, 10, 
            11, 13, 15, 16, 17, 19, 19, 20, 50)
n <- length(x); m.x <- mean(x); s.x <- sd(x); 
alpha <- 0.05; t <- qt(alpha/(2*n), n-2)
G.hat  <- max(abs(x-m.x))/s.x; G.hat
G.crit <- ((n-1)/sqrt(n)) * sqrt(t^2 / (n-2+t^2)); G.crit

#########################################################################

x <- c(3, 4, 4, 5, 6, 6, 7, 8, 9, 10, 10, 
            11, 13, 15, 16, 17, 19, 19, 20, 50)
library(outliers)
dixon.test(x)
grubbs.test(x)

#########################################################################

                                                            # Section 7.3

                                                  # single sample methods

#########################################################################

                                                          # Section 7.3.1

                                                  # binomial distribution

                                                           
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=15)       # figure 7.12
n  <- 30
p  <- 0.7
x  <- 0:n
fx <- dbinom(x, n, p)    
plot(x, fx, type="h", ylim=c(0, 0.2), xlim=c(0,n), ylab="f(x)", xlab=" ",
     lty=3, col="grey", las=1)
points(x, fx, pch=19, cex=0.8, col="black")

Fx <- pbinom(x, n, p) 
x1 <- c(x, n+1, n+2)
Fx <- c(Fx, 1, 1)
plot(x1, Fx, type="s", las=1, ylim=c(0,1), xlim=c(0,n+2), 
     ylab="F(x)", xlab=" ")
lines(c(0,0),c(0,Fx[1]))

#########################################################################
                                                           
pbinom(25, 30, 0.7, lower.tail=FALSE)                     # binomial test
binom.test(26, 30, p=0.7, alternative="greater")
qbinom(0.95, 30, 0.7)

#########################################################################
                                                   
binom.test(15, 20, p=0.5, alternative="two.sided")         # example coin

#########################################################################

n  <- 20; x  <- 15 ; p0 <- 0.5
pbinom(n-x, n, p0, lower.tail=TRUE) + pbinom(x-1, n, p0, lower.tail=FALSE)

#########################################################################

n  <- 20; x  <- 15 ; p0 <- 0.2
P <- 0; pH <- dbinom(x, n, p0)
for (i in 0:n) P <- ifelse(dbinom(i,n,p0) <= pH, P+dbinom(i,n,p0), P); P

#########################################################################

                                   # approximation by normal distribution
                                                  
N <- 2000; n <- 400; x <- 184; p0 <- 0.40; p <- x/n     # example dealers
z <- (abs(p-p0) - 1/(2*n)) / sqrt(((p0*(1-p0))/n)*((N-n)/(N-1))); z
pnorm(z, lower.tail=F)

#########################################################################

binom.test(184, 400, p=0.40, alternative="greater")

#########################################################################
                                                   
alpha <- 0.05; beta <- 0.20                     #  sample size estimation
p0 <- c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8)
 p <- c(0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9)
ceiling(((qnorm(1-alpha) + qnorm(1-beta))^2 * 
             (p0*(1-p0) + p*(1-p))) / (p-p0)^2)

#########################################################################

power.prop.test(n=NULL, p1=0.1, p2=0.2, sig.level=0.05, 
            power=0.80, alternative="one.sided")

#########################################################################
                                                            
prob <- seq(0.01, 0.10, by=0.004); lp <- length(prob)       # figure 7.13
conf <- c(0.80, 0.90, 0.95);       lc <- length(conf)
ntab <- matrix(rep(NA, lp*lc), ncol = lp, byrow = TRUE)

for (i in 1:lc) {
  for (j in 1:lp) ntab[i,j] <- (log10(1-conf[i])/log10(1-prob[j])) }
ceiling(ntab)

par(mfrow=c(1,1), lwd=2, bty="l", ps=15)
plot(ntab[1,], prob, type="b", las=1, lty=1, pch=1, xlim=c(10, 120),
     yaxp=c(0.01, 0.20, 19), xaxp=c(10, 120, 11),
     ylab="Probability", xlab="Sample size")
lines(ntab[2,], prob, type="b", lty=1, pch=2)
lines(ntab[3,], prob, type="b", lty=1, pch=5)
abline(h=seq(20,300,20), col="grey", lty=2)
abline(h=seq(0.01, 0.10, 0.01), lty=2, col="grey")
legend(90, 0.10, pch = c(1,2,5), bty="n",
       legend=c("80% power","90% power","95% power"), cex=1.2)

#########################################################################
                                             
n <- 60; x <- 4; p0 <- 1/6                        # Likelihood ratio test
minus2ll <- 2*(x*log(x/(n*p0)) + (n-x)*log((n-x)/(n-n*p0))); minus2ll
pchisq(minus2ll, 1, lower.tail = FALSE)

#########################################################################

binom.test(c(x, n-x), p = p0, alternative="less")

#########################################################################

                                                        # Section 7.3.2.1
                                                        
m <- 9; s <- 2; n <- 25                               # one sample t-test
t.hat <- abs(m-10)/(s/sqrt(n)); t.hat
t.krit <- qt(0.975, n-1); t.krit

#########################################################################
                                       
mue        <- 85                                 # example blood pressure     
standardab <- 9
n          <- 11
sem        <- standardab / sqrt(n);   sem
mue.0      <- 80                               # expected value under H.0
tquant     <- qt(0.95, n-1); tquant            # quantile test distrib.
mkrit      <- mue.0 + tquant*sem;   mkrit      # critical value         
p.val <- pt((mue-mue.0)/sem, n-1, lower.tail=FALSE)                                            
mue.a      <- 88                               # expected value under H.A

x.i        <- seq(mue.0 - 3*sem, mue.a + 3*sem, by=0.1)
f0.i       <- dnorm(x.i, mean=mue.0, sd=sem)
fa.i       <- dnorm(x.i, mean=mue.a, sd=sem)

                                                            # figure 7.14
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=15)
plot(x.i, f0.i, col="black", xlim=c(70, 100), ylim=c(0,0.15), yaxs="r",
     las=1, type="l", xlab="mean DPD (mmHg)", ylab=" ")
abline(v=mkrit, col="black")
text(77, 0.151, "acceptance area", col="black", cex=0.8)
xval  <- seq(mkrit, mue.a + 3*sem, by=0.01)
xarea <- c(mkrit, xval); yarea <- c(0, dnorm(xval, mean=mue.0, sd=sem)) 
polygon(xarea, yarea, col="black", density=15, angle=135)
text(91, 0.02, expression(alpha == 0.05), cex=1)

plot(x.i, f0.i, col="black", xlim=c(70, 100), ylim=c(0,0.15), yaxs="r",
     las=1, type="l", xlab="mean DBP (mmHg)", ylab=" ")
abline(v=mkrit, col="black")
text(77, 0.151, "acceptance area", col="black", cex=0.8)
xval  <- seq(mkrit, mue.a + 3*sem, by=0.01)
xarea <- c(mkrit, xval); yarea <- c(0, dnorm(xval, mean=mue.0, sd=sem)) 
polygon(xarea, yarea, col="black", density=15, angle=135)
lines(x.i, fa.i, col="black")
text(93, 0.151, "rejection area", col="black", cex=0.8)
xval  <- seq(mue.0 - 3*sem, mkrit, by=0.01)
xarea <- c(xval, mkrit); yarea <- c(dnorm(xval, mean=mue.a, sd=sem), 0) 
polygon(xarea, yarea, col="black", density=15)
text(79,0.03, expression(beta == 0.14), cex=1)

#########################################################################
                                        
tstat      <- (86 - mue.0)/sem;   tstat                  # test statistic
                                      
pt(tstat, n-1, lower.tail=F)                          # p-value one sided

                                                                  # power            
beta       <- pt((mkrit - mue.a)/sem, n-1, lower.tail=T); beta; 1-beta

#########################################################################

                                               # example body temperature 
temp <- c(36.8, 37.2, 37.5, 37.0, 36.9, 37.4, 37.9, 38.0)
t.test(temp, alternative="greater", mu=37)

#########################################################################
                                        
d <- 15; s <- 30                                 # power- and sample size
effekt <- d / s
alpha <- 0.05; beta <- 0.20
n.1 <- ceiling((qnorm(1-alpha) + qnorm(1-beta))^2 / effekt^2); n.1
n.2 <- ceiling((qt(1-alpha, n.1-1) + qt(1-beta, n.1-1))^2 / effekt^2); n.2
n.3 <- ceiling((qt(1-alpha, n.2-1) + qt(1-beta, n.2-1))^2 / effekt^2); n.3

#########################################################################

power.t.test(delta=15, sd=30, sig.level=0.05, power=0.80, 
             type="one.sample",  alternative="one.sided")

#########################################################################
                                                            
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=15)       # figure 7.15
power <- power.t.test(n=10:50, delta=15, sd=30, 
                      sig.level=0.05, power=NULL, type="one.sample", 
             alternative="one.sided")$power
plot(10:50, power, xlim=c(10,50), ylim=c(0.30, 1.0), type="b",las=1,
     xlab="Sample size", ylab="Power"); grid()

#########################################################################

                                            # one-sample equivalence test

                       # quantiles to the non-central Fisher distribution 
myqf <- function(p, df1, df2, ncp) {
        uniroot(function(x) pf(x, df1, df2, ncp) - p, c(0, 100)) $ root }
n <- 23; d <- 0.16; s.d <- 4.0; eps <- 0.5
t.hat <- (d/s.d)*sqrt(n); t.hat                       # test statistic   
c <- sqrt(myqf(0.05, 1, n-1, ncp=n*eps^2)); c         # critical value 

########################################################################

                                                         # Section 7.3.3

                                                # one-sample median test

                               #  quantiles to the Wilcoxon distribution
qsignrank(0.95, 6:20, lower.tail = TRUE)

########################################################################

x <- c(12, 16, 18, 24, 26, 31, 38, 40)       # Wilcoxon signed rank test
wilcox.test(x, alternative="two.sided", mu=30, conf.int=TRUE)

########################################################################

                                                       # Section 7.3.6.2
                                                                                             
library(tseries)                            # iteration test / runs-Test
werte <- c(18, 17, 18, 19, 20, 19, 19, 21, 18, 21, 22)
med   <- median(werte)
x     <- as.factor(werte<med); x
runs.test(x, alternative="two.sided")

########################################################################

                                                       # Section 7.3.6.4

cox.stuart.test <- function (x) {                      # Cox-Stuart test        
  method = "Cox-Stuart Test for trend change"
  leng = length(x);   
  apross = round(leng) %% 2    
  if (apross == 1) {delete = (length(x)+1)/2;x = x[-delete ] }
  half = length(x)/2
  x1 = x[1:half];       x2 = x[(half+1):(length(x))]
  difference = x1-x2;   signs = sign(difference)
  signcorr = signs[signs != 0]
  pos = signs[signs>0];   neg = signs[signs<0]
  if (length(pos) < length(neg)) {
    prop = pbinom(length(pos), length(signcorr), 0.5)
    names(prop) = "Upword trend, P-value"
    rval <- list(method = method, statistic = prop)
    class(rval) = "htest";     return(rval)
  }
  else {
    prop = pbinom(length(neg), length(signcorr), 0.5)
    names(prop) = "Downwards Trend, P-value"
    rval <- list(method = method, statistic = prop)
    class(rval) = "htest";     return(rval)
  }
}
mileage <- c(9.8,9.9,10.0,9.8,9.2,9.4,9.5,9.6,9.8,9.3,8.9,8.7,9.2,9.3)
cox.stuart.test(mileage)

########################################################################

                                                         # Section 7.3.7

                                  # one-sample test Poisson distribution

1 - ppois(15, .10 * 100, lower.tail = TRUE)       # one sample test
poisson.test(16, 0.10*100, alternative="greater")
ppois(16, 1.6*10)                                 # Power

########################################################################
 
                          # sample size and power for the one-sample test
lA <- 0.63; l0 <- 1.26
alpha <- 0.05; beta  <- 0.10; power <- 1 - beta
n <- 1/4*((qnorm(1-alpha) + qnorm(1-beta))/(sqrt(lA) - sqrt(l0)))^2
n <- ceiling(n); n

########################################################################

lA <- 0.63; l0 <- 1.26
alpha <- 0.05; n <- 20
power <- 1-pnorm(2*sqrt(n)*(sqrt(lA)-sqrt(l0)) + qnorm(1-alpha))
power
alpha <- 0.05; n <- 15
power <- 1-pnorm(2*sqrt(n)*(sqrt(lA)-sqrt(l0)) + qnorm(1-alpha))
power

########################################################################

                                                       # Section 7.3.7.2

                      # sample size and power for testing a defect rate

n_defects <- function(lim, tol=1.5, alpha=0.10, power=0.90) {
  z_alpha <- qnorm(1-alpha);   z_power <- qnorm(power)
  units   <- ceiling(tol/lim * ((z_alpha/sqrt(tol) + z_power)/(tol-1))^2)
  defects <- ceiling(z_alpha*sqrt(units*lim) + units*lim)
  cat("\n","There are",units,"units to check...!","\n",
      "The permissible number of errors",lim,"is exceeded by",tol,
      "\b-times","\n",
      "if more than",defects,"errors occur!")    }
                                                   # example solar cells
n_defects(lim=4, tol=1.5, alpha=0.10, power=0.90)

########################################################################

                                                           # Section 7.4

                                                    # two-sample methods

########################################################################

                                                         # Section 7.4.1
                                                         
n1 <- 41; sq1 <- 25;                        # F-test comparing variances   
n2 <- 31; sq2 <- 16;
f.hat <- sq1 / sq2;                 f.hat
f.tab <- qf(0.95, n1-1, n2-1);      f.tab

x <- round(rnorm(10, mean=90, sd=10)); x
y <- round(rnorm(15, mean=90, sd=15)); y
var.test(x, y, ratio=1, altzernative="two.sided", conf.level=0.95)

########################################################################

                                                         # Section 7.4.1

pwr.var <- function(ratio, n=NA, power=NA,       # power and sample size
                    alpha=0.05, alternative="one-sided") {
  p.alpha <- ifelse (alternative=="one-sided", 1-alpha, 1-alpha/2)
  if (is.na(n) & !is.na(power)) {               # sample size
    g <- function(n) {power - (1-pf((1/ratio) * qf(p.alpha, n-1, n-1), n-1, n-1))}
    u <- uniroot(g, c(ratio, 1000 * ratio))$root
    n.r <- ceiling(u);        p.r <- power
  }
  if (!is.na(n) & is.na(power)) {               # power
    pwr <- 1 - pf((1/ratio) * qf(p.alpha, n-1, n-1), n-1, n-1)
    p.r <- round(pwr, 5);     n.r <- n
  }
  cat("Sample size and power for comparing two variances","\n",
      "Ratio V1/V2        :",ratio,"\n",
      "Signif. level      :",alpha,alternative,"\n",
      "Power              :",p.r,"\n",
      "Sample size (n1=n2):",n.r,"\n")
}

########################################################################

pwr.var(ratio=3, power=0.90, alpha=0.05)
pwr.var(ratio=3, n=31, alpha=0.05)

########################################################################

                                                       # Section 7.4.1.6

cv.test <- function(ni, xi, si){  # comparing coefficienmts of variation
  N   <- sum(ni); K   <- length(ni); vi <- si / xi
  ui  <- (ni*vi^2)/(1+vi^2)
  sn <- (N-K)*log(sum(ui/(N-K)))-sum((ni-1)*log(ui/(ni-1))) 
  sd <- 1 + (1/(3*(K-1)) * sum(1/(ni-1))-(1/(N-K)))
  stat <- sn/sd;  p <- pchisq(stat, df=K-1, lower.tail=F)
  result <- list("Chi-square statistic" = stat, "pval" = p)
  return(result) 
}

#########################################################################

ni <- c(54, 23); xi <- c(146.8, 31.2); si <- c(53.8, 31.0)
cvi <- (si/xi); round(cvi, 4)
cv.test(ni, xi, si)

########################################################################

library(cvequality)
asymptotic_test2(k=2, n=c(54, 23), s=c(53.8, 31.0), x=c(146.8, 31.2))

########################################################################

                                                         # Section 7.4.2
                                                       
siegel.tukey.test = function(x=NA, y=NA, ties=T) {   # Siegel-Tukey test
  n1 <- length(x);   n2 <- length(y);   n  <- n1 + n2
                                       
  x <- c(x, y) ;  v <- c( rep(1, n1), rep(0, n2) )
  d <- rbind(x,v)[,order(x)]         
  x.levels <- unique (x)
                                   # adjustment for odd sample size
  if (n%%2==1) { d <- d[,c(1:trunc(n/2),(trunc(n/2)+2):n)] ;  n <- n - 1 }
  g = rep(NA, n)                   # generation of the rank distribution
  for (i in 1:n) {                    
   if                      (i%%2==0 & i  <n & i<=n/2) { g[i] <- 2*i       }
     else if               (i%%2==0 & n/2<i & i<=n  ) { g[i] <- 2*(n-i)+2 }
            else if        (i%%2==1 & 1 <=i & i<=n/2) { g[i] <- 2*i -1    }
                   else if (i%%2==1 & n/2<i & i<n   ) { g[i] <- 2*(n-i)+1 }
                 }                               
  if (ties) {                      # ties?
    for (xl in x.levels) {
      x.i <- (d[1,]==xl) 
      if (sum(x.i)>1) { g[x.i] <- mean(g[x.i]) }
                         }
            }
  ST <- sum(g*d[2,])               # calculation of the test statistic
                                   # P-value from standard normal distr.
  eins    <- ifelse (2*ST > n1*(n1+n2+1), -1, +1)
  z.hat   <- (2*ST - n1*(n1+n2+1)+eins)/sqrt(n1*(n1+n2+1)*(n2/3))
  p.value <- 2*pnorm(z.hat, lower.tail=FALSE)
  cat("     Siegel-Tukey-Test ","\n",
      "ST =", ST, "P-value (two-sided) =", p.value, "\n")
}

########################################################################

A  <- c(10.1, 7.3, 12.6, 2.4, 6.1, 8.5, 8.8, 9.4, 10.1, 9.8)   # example
B  <- c(15.3, 3.6, 16.5, 2.9, 3.3, 4.2, 4.9, 7.3, 11.7, 13.1)
siegel.tukey.test(A, B, ties=TRUE)

########################################################################

                                                         # Section 7.4.3

                                                   # Ansari-Bradley test
A <- c(10.1, 7.3, 12.6, 2.4, 6.1, 8.5, 8.8, 9.4, 10.1,  9.8)
B <- c(15.3, 3.6, 16.5, 2.9, 3.3, 4.2, 4.9, 7.3, 11.7, 13.1)

ansari.test(A, B, alternative="two.sided")

########################################################################

                                                           # LePage test

A <- c(5.9, 6.0, 6.4, 7.0, 6.6, 7.7, 7.2, 6.9, 6.2); m <- length(A)
B <- c(5.3, 5.6, 5.5, 5.1, 6.2, 5.8, 5.8);           n <- length(B)
N <- m + n 
W <- wilcox.test(A, B); W; S <- 60.5                     # Wilcoxon test
S1 <- (S - n*m/2) / sqrt(m*n*(N+1)/12); S1
A <- ansari.test(A, B); A; S <- 43.5                     # Ansari test
if (N%%2==0) { 
   S2 <- (S - (m*(N+2)/4)) / sqrt((m*n*(N^2-4)/(48*(N-1))));
   S2 <- (S - (m*(N+1)^2)/(4*N)) / sqrt(m*n*(N+1)*(3+N^2) / (48*N^2))}; S2
lepage <- S1^2 + S2^2; lepage                            # Lepage test
pchisq(lepage, 2, lower.tail=FALSE)

########################################################################

                                                         # Section 7.4.4
                                                       
n1 <- 16; xbar1 <- 14.5; s1 <- 4                     # two-sample t-test
n2 <- 14; xbar2 <- 13.0; s2 <- 3
Q1 <- (n1 - 1)*s1
Q2 <- (n2 - 1)*s2
t.hat <- (xbar1 - xbar2) / sqrt(((n1 + n2)/(n1*n2)) * 
            ((Q1 + Q2)/(n1+n2-2))); t.hat
t.krit <- qt(0.975, n1+n2-2); t.krit

########################################################################

x <- c(8.8, 8.4, 7.9, 8.7, 9.1, 9.6)               # example coagulation
y <- c(9.9, 9.0, 11.1, 9.6, 8.7, 10.4, 9.5)
t.test(x, y, alternative="two.sided", var.equal=TRUE)

qt(0.975, 11)

########################################################################

                                                     # unequal variances
aktiv   <- c(29.5, 44.9, 54.2, 55.4, 58.5, 59.8, 60.1, 84.2, 97.5)
inaktiv <- c(32.3, 32.7, 37.4, 38.4, 40.1, 
                    40.6, 45.3, 45.6, 52.0, 60.3, 60.5)
t.test(aktiv, inaktiv, alternative="greater", var.equal=FALSE)

########################################################################

                                                # sample size and power
power.t.test(delta=15, sd=20, sig.level=0.05, power=0.80, 
             type="two.sample", alternative="one.sided")

power.t.test(n=20, sd=sqrt(0.905), sig.level=0.05, power=0.90, 
             type="two.sample", alternative="two.sided")

########################################################################

                                                 # example oxygen uptake
m1 <- 43.5;  m2 <- 46.2;  sp <- 2.8;   n  <- 15; alpha <- 0.05
nu    <- (n - 1)*2
quant <- qt(alpha/2, df=nu, lower.tail = FALSE)
nonc  <- sqrt(n/2) * abs(m1-m2)/sp; round(nonc, 2)
power <- pt(quant, df=nu, ncp=nonc, lower.tail = FALSE) + 
				pt(-quant, df=nu, ncp=nonc, lower.tail = TRUE)
round(power, 4)

power.t.test(n=n, delta=abs(m1-m2), sd=sp, sig.level=alpha, 
             alternative="two.sided")

########################################################################
                                                         
beta  <- c(0.3, 0.2, 0.1)                                   # table 7.23
d     <- c(0.1, 0.2, 0.3, 0.4, 0.5, 0.7, 1.0, 1.5)

alpha <- 0.05
n11    <- ceiling(((qnorm(1-alpha)+qnorm(1-0.3))^2 * 2) / d^2); n11
n12    <- ceiling(((qnorm(1-alpha)+qnorm(1-0.2))^2 * 2) / d^2); n12
n13    <- ceiling(((qnorm(1-alpha)+qnorm(1-0.1))^2 * 2) / d^2); n13
n21    <- ceiling(((qnorm(1-alpha/2)+qnorm(1-0.3))^2 * 2) / d^2); n21
n22    <- ceiling(((qnorm(1-alpha/2)+qnorm(1-0.2))^2 * 2) / d^2); n22
n23    <- ceiling(((qnorm(1-alpha/2)+qnorm(1-0.1))^2 * 2) / d^2); n23

tab <- matrix(data = NA, nrow = 8, ncol = 7, byrow = FALSE, dimnames = NULL)
tab[,1] <- d
tab[,2] <- n11; tab[,3] <- n12; tab[,4] <- n13
tab[,5] <- n21; tab[,6] <- n22; tab[,7] <- n23 
as.data.frame(tab)

alpha <- 0.01
n11    <- ceiling(((qnorm(1-alpha)+qnorm(1-0.3))^2 * 2) / d^2); n11
n12    <- ceiling(((qnorm(1-alpha)+qnorm(1-0.2))^2 * 2) / d^2); n12
n13    <- ceiling(((qnorm(1-alpha)+qnorm(1-0.1))^2 * 2) / d^2); n13
n21    <- ceiling(((qnorm(1-alpha/2)+qnorm(1-0.3))^2 * 2) / d^2); n21
n22    <- ceiling(((qnorm(1-alpha/2)+qnorm(1-0.2))^2 * 2) / d^2); n22
n23    <- ceiling(((qnorm(1-alpha/2)+qnorm(1-0.1))^2 * 2) / d^2); n23

tab <- matrix(data = NA, nrow = 8, ncol = 7, byrow = FALSE, dimnames = NULL)
tab[,1] <- d
tab[,2] <- n11; tab[,3] <- n12; tab[,4] <- n13
tab[,5] <- n21; tab[,6] <- n22; tab[,7] <- n23 
as.data.frame(tab)

########################################################################

                                                       # Section 7.4.4.4
                                                      
two.sample.bootstrap <- function(x, y, B=999) {       # bootstrap t-test
  x <- x[complete.cases(x)];  y <- y[complete.cases(y)]
  n.x <- length(x);           n.y <- length(y)
  mean.x <- mean(x, na.rm=T); mean.y <- mean(y, na.rm=T)
  stdv.x <- sd(x, na.rm=T);   stdv.y <- sd(y, na.rm=T)
  d.x    <- stdv.x^2/n.x;        d.y <- stdv.y^2/n.y
  W      <- rep(NA, B)
  for (i in 1:B) {
    xi <- sample(x, n.x, replace=T);   yi <- sample(y, n.y, replace=T)
    mean.xi <- mean(xi, na.rm=T); mean.yi <- mean(yi, na.rm=T)
    stdv.xi <- sd(xi, na.rm=T);   stdv.yi <- sd(yi, na.rm=T)
    d.xi    <- stdv.xi^2/n.x;        d.yi <- stdv.yi^2/n.y
    W[i]    <- ((mean.xi-mean.yi)-(mean.x-mean.y))/sqrt(d.xi+d.yi)  }
  W <- sort(W); L <- round(0.025*B,0); U <- round(0.975*B,0)
  ci95.L <- round(mean.x - mean.y + W[L]*sqrt(d.x+d.y),3)
  ci95.U <- round(mean.x - mean.y + W[U]*sqrt(d.x+d.y),3)
  cat("       Bootstrap: t-test variant","\n",
      "Means:",round(mean.x,3),"und",round(mean.y,3),"\n",
      "Difference  :",round(mean.x-mean.y,3),
      "with 95% confidence limits: [",ci95.L,",",ci95.U,"]","\n")
}
aktiv   <- c(29.5, 44.9, 54.2, 55.4, 58.5, 59.8, 60.1, 84.2, 97.5)
inaktiv <- c(32.3, 32.7, 37.4, 38.4, 40.1, 40.6, 45.3, 45.6, 52.0, 60.3, 60.5)

two.sample.bootstrap(aktiv, inaktiv, B=999)

########################################################################

t.test(aktiv, inaktiv, alternative="two.sided", var.equal=FALSE)

wilcox.test(aktiv, inaktiv, alternative = "two.sided", exact = TRUE, correct = FALSE) 


########################################################################

                                                       # Section 7.4.4.5

                                                         # Hotelling's T
hotelling <- function(x1, x2) {                                   
  k1 <- ncol(x1);  k2 <- ncol(x2)              # dimensions in x1 und x2
  if (k2 != k1) stop("Error in dimensions: x1 has", k1, 
                     "and x2 has", k2, "columns - dimensions!")
  p <- k1; n1    <- nrow(x1); n2 <- nrow(x2)       # number of variables
  xbar1 <- apply(x1, 2, mean); xbar2 <- apply(x2, 2, mean)
  diffbar <- xbar1 - xbar2
  v <- ((n1-1)*var(x1) + (n2-1)*var(x2)) / (n1+n2-2)
  # Hotelling's T2
  T2 <- n1*n2/(n1+n2) * (diffbar %*% solve(v) %*% diffbar)
  F  <- ((n1+n2-p-1)/((n1+n2-2)*p))*T2     # transform to Fisher
  pvalue <- 1-pf(F, p, n1+n2-p-1)
  D2 <- diffbar %*% solve(v) %*% diffbar   # Mahalanobis distance
  cat(" Hotelling's multivariate T-statistic","\n",
      " Differences    : ", diffbar,"\n",
      " Hotelling's T2 : ", T2,"\n",
      " F-statistic    : ", F,"(P-value = ",pvalue,")","\n",
      " Mahalanobis D2 : ", D2,"\n")
}

########################################################################

schweiss  <- read.csv("sweat.csv", header=T, sep=";", dec=",")
data      <- with(schweiss, cbind(Sweat, Na, Ka))
trained   <- subset(data, schweiss$Gruppe==1)
untrained <- subset(data, schweiss$Gruppe==2)
hotelling(trained, untrained)

########################################################################

library(Hotelling)
print(hotelling.test(trained, untrained))

########################################################################

                                                         # Section 7.4.5

                                                        # paired samples
treated   <- c(4.0, 3.5, 4.1, 5.5, 4.6, 6.0, 5.1, 4.3)
untreated <- c(3.0, 3.0, 3.8, 2.1, 4.9, 5.3, 3.1, 2.7)
t.test(treated, untreated, alternative = c("two.sided"), paired = TRUE)

########################################################################

                                                         # Section 7.4.6
                                                
n1 <- 3;  n2 <- 5                               # Wilcoxon rank sum test
U  <- 0:(n1*n2 +1)
W  <- U + n1*(n1+1)/2
f  <- dwilcox(U, n1, n2)
F  <- pwilcox(U, n1, n2)
                                                           # figure 7.16  
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="n", ps=15) 
plot(W, f, type='h', col="black", xlab="Sum of ranks", las=1,
     ylab="f(r)", xlim=c(5,25), ylim=c(0,0.12))    
plot(W, F, type="s", col="black", xlab="Sum of ranks", las=1,
     ylab="F(r)", xlim=c(5,25))   

########################################################################

m <- 2:10; n <- 10
utab.l <- qwilcox(0.025, m, n, lower.tail=TRUE)
rtab.l <- utab.l + m*(m+1)/2
utab.u <- qwilcox(0.975, m, n, lower.tail=TRUE)
rtab.u <- utab.u + m*(m+1)/2
utab.l; utab.u              # lower / upper quantiles U-statistic    
rtab.l; rtab.u              # lower / upper quantiles runk sums  

########################################################################

A <- c(7, 14, 22, 36, 40, 48, 49, 52); n1 <- length(A)
B <- c(3, 5, 6, 10, 17, 18, 20, 39);   n2 <- length(B)
All <- c(A, B)                         # combine both samples      
grp <- c(rep(1, n1), rep(2, n2))       # mark the bgroup         
rnk <- rank(All)                       # assign rank numbers        
xdata <- matrix(c(grp,All,rnk),ncol=3) # build the matric               
Names <- c("group","value","rank")     # names of data columns         
dimnames(xdata) <- list(NULL, Names); t(xdata)
data <- as.data.frame(xdata); attach(data)
r1 <- sum(rank[group==1]); r1
r2 <- sum(rank[group==2]); r2
u1 <- r2 - n2*(n2+1)/2; u1
u2 <- r1 - n1*(n1+1)/2; u2

########################################################################

wilcox.test(A, B, alternative="greater", conf.int=TRUE, conf.level=0.95)

########################################################################

A <- c(63, 68, 70, 81, 97, 104)
B <- c(91, 92, 95, 96, 99)
wilcox.test(A, B, alternative="two.sided")

########################################################################

                                      
A <- c(5, 5, 8, 9, 13, 13, 13, 15)    # Wilcoxon rank sum test with ties
B <- c(3, 3, 4, 5,  5,  8, 10, 16)
wilcox.test(A, B, alternative="two.sided")

########################################################################

library(coin)
wert <- c(A, B); grp <- as.factor(c(rep("A",length(A)),rep("B",length(B))))
dat <- as.data.frame(c(wert, grp))
wilcox_test(wert ~ grp, data = dat, alternative="two.side", 
                        distribution = "exact", conf.int = TRUE)

########################################################################

                                                       # Section 7.4.6.2

mue1  <- 0; sigma <- 1                                # effect statistic
d     <- c(0.2, 0.5, 0.8)
mue2  <- d * sigma
                                                           # figure 7.17
par(mfrow=c(2,2), lwd=2, font.axis=2, bty="n", ps=15)
x <- seq(-3, 4, by=0.1)
f  <- dnorm(x, mean=mue1, sd=sigma)
f1 <- dnorm(x, mean=mue2[1], sd=sigma)
plot(x, f, type="b", xlab="d=0.2; P(X>Y)=0.56", ylab="Density f(x)", 
     main="A) small effect", col="grey", cex=0.8)
lines(x, f1) 
f2 <- dnorm(x, mean=mue2[2], sd=sigma)
plot(x, f, type="b", xlab="d=0.5; P(X>Y)=0.64", ylab="Density f(x)", 
     main="B) medium effect", col="grey", cex=0.8)
lines(x, f2) 
f3 <- dnorm(x, mean=mue2[3], sd=sigma)
plot(x, f, type="b", xlab="d=0.8; P(X>Y)=0.71", ylab="Density f(x)", 
     main="C) strong effect", col="grey", cex=0.8)
lines(x, f3) 
delta <- seq(-1, 1, b=0.1); F <- pnorm(delta/sqrt(2), mean=0, sd=1)
plot(delta, F, type="l", ylim=c(0.4, 0.8), 
            xlim=c(0, 1), xlab="d", ylab="P(X>Y)", 
            main="D) association between effect strenghts", cex=0.8)
y <- pnorm(0.2/sqrt(2), mean=0, sd=1)
lines(c(0.2, 0.2), c(0, y), col="grey")
lines(c(-2, 0.2), c(y, y), col="grey")
y <- pnorm(0.5/sqrt(2), mean=0, sd=1)
lines(c(0.5, 0.5), c(0, y), col="grey")
lines(c(-2, 0.5), c(y, y), col="grey")
y <- pnorm(0.8/sqrt(2), mean=0, sd=1)
lines(c(0.8, 0.8), c(0, y), col="grey")
lines(c(-2, 0.8), c(y, y), col="grey") 

########################################################################

                                                # example kidney weights
placebo <- c(1.69, 1.96, 1.76, 1.88, 2.30, 1.97, 1.69, 1.63, 2.01, 
             1.92, 1.93, 1.56, 1.71); n <- length(placebo)
verum   <- c(2.12, 1.88, 2.15, 1.96, 1.83, 2.03, 2.19, 2.10, 2.15, 
             2.00, 2.25, 2.49, 2.43, 1.89, 2.38, 2.37, 2.05, 2.00)
m <- length(verum)
d <- matrix(rep(NA, n*m), nrow=n)
for (i in 1:n) {
     for (j in 1:m) {
     if (placebo[i]  < verum[j]) d[i, j] <- 1
     if (placebo[i] == verum[j]) d[i, j] <- 0.5
     if (placebo[i]  > verum[j]) d[i, j] <- 0
}}
P.hat <- sum(apply(d, 1, sum))/(m*n); P.hat           
s     <- sqrt(((n-1)*var(verum) + (m-1)*var(placebo))/(n+m-2))
d.hat <- (mean(verum)-mean(placebo))/ s; d.hat       


########################################################################
                                                             
c <- seq(1.5, 2.5, by=0.01); nc <- length(c)                 # ROC curve
rocx <- rep(NA, nc); rocy <- rep(NA,nc)
for (i in 1:nc)   {
    x <- 0; y <- 0
    for (k in 1:m) {if (verum[k]   > c[i]) y <- y + 1}
    for (k in 1:n) {if (placebo[k] > c[i]) x <- x + 1}
    rocx[i] <- x/n; rocy[i] <- y/m
}

                                                           # figure 7.18
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="n", ps=15)
plot(rocx, rocy, type="l", xlab="P(Y>c) - placebo", ylab="P(X>c) - verum")
abline(0,1, lty=2); text(0.5, 0.2, "AUC = 0.85", cex=1.3)

########################################################################
                                                             
library(ROCR)                                            # library(ROCR)
par(mfcol=c(1,1),lwd=2, font.axis=2, bty="n", ps=14, las=0) 
pred <- prediction(c(verum, placebo),c(rep(1, m), rep(0, n))) 
perf <- performance( pred, "tpr", "fpr" )
plot(perf)

########################################################################

                                                       # Section 7.4.6.3

                                 #  sample size and power for the U-test 
npwr.Utest <- function(effect, alpha=0.05, alternative="two-sided", 
                       power=NULL, N=NULL, c=0.5) {
  if (sum(sapply(list(N, power, alpha), is.null)) != 1) 
    stop("Error: Only one of N or power can be zero")
  sig.level <- ifelse (alternative=="one-sided", alpha*2, alpha)
  if (is.null(N)) {
    N  <- (qnorm(1-power) + qnorm(sig.level/2))**2 / (12*c*(1-c)*(effect-0.5)**2) 
    n1 <- ceiling(N*c); n2 <- ceiling(N*(1-c))
    Power <- power   }
  if (is.null(power)) {
    sigma0 <- sqrt(1/(12*c*(1-c)))
    Power <- pnorm((sqrt(N)*abs(effect-0.5)+qnorm(sig.level/2) * sigma0) / sigma0)
    n1 <- round(N*c,0); n2 <- N - n1   }
  cat("Sample size n1=",n1,"und n2=",n2,"\n",
      "Effect P(X>Y)          =",effect,"\n",
      "Signifikance level     =",alpha,"\n",
      "Alternative hypothesis =",alternative,"\n",
      "Power                  =",round(Power*100,2),"%")
}

npwr.Utest(effect=2/3, alpha=0.05, alternative="one-sided", power=0.80)

npwr.Utest(effect=2/3, alpha=0.05, alternative="one-sided", N=76)

########################################################################

library(rankFD)
noether(alpha=0.10, power=0.80, t=0.5, p=2/3)

########################################################################

                                                         # Section 7.4.7
                                                        
                              # Wilcoxon matched paired signed rank test
M1 <- c(0.47, 1.02, 0.33, 0.70, 0.94, 0.85, 0.39, 0.52, 0.47)
M2 <- c(0.41, 1.00, 0.46, 0.61, 0.84, 0.87, 0.36, 0.52, 0.51)
D  <- M1 - M2; D
wilcox.test(M1, M2, alternative="two.sided", paired=TRUE)

########################################################################

library(coin)
wilcoxsign_test(M1 ~ M2, alternative = "two.sided", distribution = exact())

########################################################################

                                                         # pseudo median
pseudo.median <- function(x) {
    d <- sort(x); n <- length(d); W <- rep(NA, (n*(n+1))/2); k <- 0
    for (i in 1 : n) { 
    for (j in i : n) { 
           k <- k+1; W[k] <- (d[i]+d[j])/2 } }
    median(W)
}
data <- c(-2, 4, 8, 25, -5, 16, 3, 1, 12, 17, 20, 9)
pseudo.median(data); median(data)

########################################################################

                                                        # Walsh averages
data <- c(-2, 4, 8, 25, -5, 16, 3, 1, 12, 17, 20, 9)
Wmat <- outer(data, data, "+")/2
Walsh_Averages <- c(Wmat[lower.tri(Wmat)], diag(Wmat));
pseudo_Median  <- median(Walsh_Averages); pseudo_Median
Wilcoxon_Stat  <- length(Walsh_Averages[Walsh_Averages>0]); Wilcoxon_Stat

########################################################################

n  <- length(data); Walsh_Averages <- sort(Walsh_Averages)
q1 <- (n*(n+1))/2 + 1 - qsignrank(0.975,n)
q2 <- qsignrank(0.975, n)
KI_u <- Walsh_Averages[q1]; KI_u
KI_o <- Walsh_Averages[q2]; KI_o

########################################################################

wilcox.test(data, conf.int=TRUE)

########################################################################

                                                       # Section 7.4.7.3 
                               
                                           # sign test by Dixon und Mood

sign_test <- function(x=0, y=NULL, alternative="two-sided") {
  n <- sum((x-y)!=0)                       # differences unequal zero
  T <- sum(x < y) 
  if (alternative=="less")    p.val <- pbinom(T, n, 0.5)
  if (alternative=="greater") p.val <- 1-pbinom(T-1, n, 0.5)
  if (alternative=="two-sided")
    p.val <- 2*min(1-pbinom(T - 1, n, 0.5), pbinom(T, n, 0.5))
  cat("\n","Sign test for",n,"pairs of values: T=",T,"; P =",p.val,"\n")
}

                                                # example reaction times
without <- c(202, 182, 207, 184, 190, 197, 224, 171, 194, 203, 192, 215, 204, 178)
with    <- c(211, 194, 200, 201, 204, 209, 230, 186, 206, 218, 192, 231, 199, 197)
sign_test(without, with, alternative="two-sided")

########################################################################

                                                       # Section 7.4.7.4
                                                        
                            # sample size to sign test and Wilcoxon test

                                                            # table 7.27
beta <- c(0.10, 0.20); alpha <- c(0.10, 0.05, 0.01)
p    <- c(3/5, 2/3, 3/4, 4/5); o <- p / (1-p)
z.alpha <- qnorm(1-alpha); z.beta  <- qnorm(1-beta)

tab <- array(0, dim=c(4,3,2), dimnames=list(round(p, 2),alpha,beta))
for (i in 1:4) { for (j in 1:3) { for (k in 1:2) 
  tab[i,j,k] <- ceiling((z.alpha[j] + z.beta[k])^2 / (4*(p[i] - 0.5)^2)) } }
out <- cbind(o, tab[,,1], tab[,,2]); out

                                                            # table 7.28
tab <- array(0, dim=c(4,3,2), dimnames=list(round(p, 2),alpha,beta))
for (i in 1:4) { for (j in 1:3) { for (k in 1:2) 
  tab[i,j,k] <- ceiling((z.alpha[j] + z.beta[k])^2 / (3*(p[i] - 0.5)^2)) } }
out <- cbind(o, tab[,,1], tab[,,2]); out

########################################################################

                                                         # Section 7.4.8

                                               # two-sample Poisson test 

x <- 10;  n1 <- 100                                         # salmonella
y <- 2;   n2 <- 100
q0 <- 1; pq <- (n1/n2)*q0 / (1 + (n1/n2)*q0)
p1 <- binom.test(x, x+y, pq, alternative="greater")$p.value
p2 <- binom.test(x, x+y, pq, alternative="less")$p.value
p  <- 2*min(p1, p2); p

poisson.test(x=c(x, y), T=c(n1, n2), r=1, alternative="two.sided")

########################################################################

                                                  # invoice verification
poisson.test(x=c(6, 16), T=c(500, 500), alternative="two.sided")

poisson.test(x=c(5, 17), T=c(500, 500), alternative="two.sided")

########################################################################

x <- 50; n1 <- 3000                                    # incidence rates
y <- 30; n2 <- 3000
l1 <- x/n1; l2 <- y/n2
z <- log(l1/l2) / (sqrt(1/x + 1/y)); z
p <- 2*pnorm(z, lower.tail=F);  p                           # two-sided

########################################################################

poisson.test(x=c(x, y), T=c(n1, n2), r=1, alternative="two.sided")

########################################################################

z.alpha <- z/2                                          # power two-ided 
z.beta  <- log(l1/l2) / (sqrt(1/x + 1/y)) - z.alpha
power   <- pnorm(z.beta, lower.tail=T); power

########################################################################
                                                     
l1 <- 0.010; l2 <- 0.005; ratio <- l1/l2             # sample size
alpha <- 0.05; z.alpha <- qnorm(1-alpha)             # one-sided
power <- 0.80; z.beta  <- qnorm(power)
x <- (1 + ratio)*((z.alpha + z.beta)/log(ratio))^2; y <- x / ratio
ceiling(x); ceiling(y)
n1 <- x / l1; n2 <- y / l2
ceiling(n1); ceiling(n2)

########################################################################

                                                         # Section 7.4.9

                                               # Kolmogorov-Smirnov test
m1 <- c(2.1, 3.0, 1.2, 2.9, 0.6, 2.8, 1.6, 1.7, 3.2, 1.7)
m2 <- c(3.2, 3.8, 2.1, 7.2, 2.3, 3.5, 3.0, 3.1, 4.6, 3.2)

ks.test(m1, m2, alternative="two.sided")

########################################################################

                                                           # figure 7.19
par(lwd=2, mfrow=c(1,1), font=2, font.axis=2, bty="l", ps=15)
n1   <- length(m1)
p1   <- cumsum(rep(1,n1)/n1)
plot(c(0,sort(m1)), c(0, p1), type="s",  xlim=c(0,8), las=1,
                 xlab=" ", ylab=expression(hat(F)))
text(1.5, 0.7, "measurement series 1", cex=1.0)
n2   <- length(m2)
p2   <- cumsum(rep(1,n2)/n2)
lines(c(0, sort(m2)), c(0,p2), type="s")
text(3.5, 0.12, "measurement series 2",  cex=1.0)
polygon(c(2.95, 2.95), c(0.2, 0.8), lty=4)

########################################################################

                                                       # Section 7.4.9.1

                                                 # Cramer-von Mises test

                                                               # example
X <- c(7.3, 7.9, 8.7, 9.0, 9.4, 10.2, 10.5, 11.1, 12.6)
Y <- c(4.3, 4.8, 5.2, 5.7, 6.0, 6.9, 8.0, 9.6, 11.8, 
       12.8, 13.1, 13.4, 13.7, 14.5, 14.9)
n1 <- length(X); n2 <- length(Y); x <- seq(0, 15, by=0.1)
hX <-hist(X, breaks=x, plot=T);  F <- cumsum(hX$counts)/n1 
hY <-hist(Y, breaks=x, plot=T);  G <- cumsum(hY$counts)/n2 
KS <- max(abs(F-G)); KS
C  <- (n1*n2)/(n1+n2)^2 * sum((hX$counts+hY$counts)*((F-G)^2)); C 

########################################################################

m1  <- c(0.6, 1.2, 1.6, 1.7, 1.7, 2.1, 2.8, 2.9, 3.0, 3.2)
m2  <- c(2.1, 2.3, 3.0, 3.1, 3.2, 3.2, 3.5, 3.8, 4.6, 7.2)
n1  <- 10; n2 <- 10; x <- seq(0, 8, by=0.1)
hm1 <- hist(m1, breaks=x, plot=T);  F <- cumsum(hm1$counts)/n1 
hm2 <- hist(m2, breaks=x, plot=T);  G <- cumsum(hm2$counts)/n2 
KS  <- max(abs(F-G)); KS
C   <- (n1*n2)/(n1+n2)^2 * sum((hm1$counts+hm2$counts)*((F-G)^2)); C 

########################################################################

library(twosamples)
cvm_test(m1,m2)

########################################################################

                                                      # Section 7.4.10.1
                                                       
                                                      # count five test
x <- c(2.4, 6.1, 7.3, 8.5, 8.8, 9.4,  9.8, 10.1, 10.1, 12.6)
y <- c(2.9, 3.3, 3.6, 4.2, 4.9, 7.3, 11.7, 13.1, 15.3, 16.5)
x.m <- mean(x);  y.m <- mean(y); n <- length(x)

max.y <- max(abs(y-y.m)); max.x <- max(abs(x-x.m))
                abs(x-x.m)>max.y; abs(y-y.m)>max.x
tab <- rbind(x, abs(x-x.m), y, abs(y-y.m), 
                abs(x-x.m)>max.y, abs(y-y.m)>max.x)
tab

########################################################################

plot(c(rep(1,n),rep(2,n)),c(abs(x-x.m),abs(y-y.m)), xlim=c(0.5,2.5),
     xlab="Sample", ylab="absolute differences")
abline(h=min(max.x, max.y))

ansari.test(x, y, alternative="two.sided")
var.test(x, y, alternative="two.sided")

########################################################################

                                                      # Section 7.4.10.3

                                                      # permutation test
x1 <- c(20, 23, 30);                   n1 <- length(x1)
x2 <- c(27, 29, 35, 38, 40, 40, 45);   n2 <- length(x2)
sum(x1)                                  # sum in 1st sample
choose(n1 + n2, n1)                      # possible sums with 3 summands

library(coin)
x <- c(x1,x2); grp <- as.factor(c(rep(1, n1), rep(2, n2)))
dat <- as.data.frame(c(grp, x))

oneway_test(x ~ grp, distribution="exact", data=dat, alternative="less")

########################################################################

                                                           # example (a)
A <- c(65, 79, 90, 75, 61, 98, 80, 75); na <- length(A)
B <- c(90, 98, 73, 79, 84, 98, 90, 88); nb <- length(B)
T.o   <- sum(A); T.o                             # test statistic        
N     <- 500                                     # number of repetitions
count <- 0; combine <- c(A, B)
for (i in 1:N) {
    if (sum(sample(combine, na)) <= T.o) count <- count + 1
    }
count/N                                           # P-value one-sided   

library(coin)
x <- c(A, B)
g <- as.factor(c(rep("A", length(A)), rep("B", length(B))))
wilcox_test(x ~ g, distribution = "exact", alternative="less")

########################################################################

                                                           # example (b)
prae <- c(90, 115,  98, 120, 93, 95, 102, 92)
post <- c(80,  95, 105, 110, 88, 92,  95, 88)
n    <- length(prae); stat <- numeric(n)
diff  <- prae - post
T.o   <- sum(diff); T.o                         # test statistic         
N     <- 500                                    # number of repetitions
count <- 0

for (i in 1:N) {
    for (j in 1:n) stat[j]=ifelse(runif(1) < 0.5, diff[j], -diff[j])
    if (sum(stat) >= T.o) count <- count + 1
    }
count/N                                         # P-value one-sided    
 
library(coin)
wilcoxsign_test(prae ~ post, alternative = "greater", distribution = exact())

########################################################################

                                                      # Section 7.4.10.5
                                                     
y1 <- c(2, 3, 4, 5, 4, 6, 7, 4, 3)                         # median test     
y2 <- c(7, 5, 6, 7, 6, 5, 4, 8, 9)
y <- c(y1, y2)
g <- as.factor(c(rep("I", length(y1)), rep("II", length(y2))))
tab <- matrix(c(6, 1, 3, 8),  nrow = 2,
       dimnames = list(sample = c("I", "II"), 
                       median = c("<5", ">=5"))); tab
fisher.test(as.factor(y < median(y)), g)$p.value      

library(coin)
dat <- as.data.frame(c(g, y))
oneway_test(y ~ g, distribution="exact", alternative="two.sided")

########################################################################

median_test(y ~ g, conf.int = FALSE, distribution="exact")

########################################################################

                                                        # Section 7.4.11

                                                  # test for equivalence  

                    # quantiles from the non-central Fisher distribution
myqf <- function(p, df1, df2, ncp) {
uniroot(function(x) pf(x, df1, df2, ncp) - p, c(0, 100)) $ root }
                                                  # example
x <- c(59.3, 58.8, 62.0, 42.6, 73.3, 54.2, 50.5, 38.0, 45.3, 50.0)
y <- c(34.9, 44.9, 52.0, 65.4, 52.5, 52.2, 68.6, 47.7, 55.9, 55.7, 53.5, 56.6)
m.x <- mean(x); s.x <- sd(x); m=length(x)
m.y <- mean(y); s.y <- sd(y); n=length(y)
T <- ((m.x - m.y) / sqrt(sum((x-m.x)^2)+ sum((y-m.y)^2)))*sqrt((m*n*(m+n-2))/(m+n))
T                                                  # critical value
eps <- 0.5                                              
c <- sqrt(myqf(0.05, 1, m+n-2, ncp=(m*n/(m+n))*eps^2)); c   

########################################################################

library(equivalence)
tost(x, y, alpha = 0.05, epsilon=0.25)$p.value
tost(x, y, alpha = 0.05, epsilon=0.50)$p.value
tost(x, y, alpha = 0.05, epsilon=0.75)$p.value

########################################################################

                                                      # Section 7.4.11.1

                                              # test for bioequivalence
R1 <- c(3.648, 8.531, 4.318, 6.974, 5.862, 3.082)
R2 <- c(4.894, 6.504, 7.372, 4.105, 2.368, 6.229)
T1 <- c(3.881, 4.835, 6.914, 5.236, 3.058, 5.722)
T2 <- c(3.671, 7.693, 4.481, 5.591, 5.311, 3.165)

RT <- log(R1) - log(T2); nRT <- length(RT); mRT <- mean(RT); sRT <- sd(RT)
TR <- log(R2) - log(T1); nTR <- length(TR); mTR <- mean(TR); sTR <- sd(TR)

mD <- (mRT + mTR)/2; mD
sD <- sqrt(((nRT-1)*sRT^2 + (nTR-1)*sTR^2)/(nRT + nTR -2)); sD

alpha <- 0.05
l.u <- mD - qt(1-alpha, nTR + nRT -2)* (sD * sqrt((1/nRT + 1/nTR) * 0.5)); l.u
l.o <- mD + qt(1-alpha, nTR + nRT -2)* (sD * sqrt((1/nRT + 1/nTR) * 0.5)); l.o

########################################################################

                                                         # Section 7.5.1
                                                 
m <- 1:100                                       # multiple test problem
p <- c(0.001, 0.01, 0.02, 0.05, 0.10)
y <- matrix(rep(NA, 5*100), nrow=5, byrow=T)
for (i in 1:5) y[i,] <- 1 - (1-p[i])^m
                                                           # figure 7.21 
par(mfcol=c(1,1), lwd=2, font.axis=2, bty="l", ps=15) 
plot(m, y[1,], ylim=c(0,1), type="l", las=1, lwd=2,
     xaxp=c(0,100,10), yaxp=c(0,1,10),
     xlab="Number uf multiple tests [m]",
     ylab="Probability")
abline(h=seq(0,1,0.1), lty=2, col="grey")
for (i in 2:5) lines(m, y[i,], lwd=2)
text(50, 0.08, "0.1%", cex=1.2); text(50, 0.45, "1%", cex=1.2)
text(44, 0.65, "2%", cex=1.2);   text(29, 0.85, "5%", cex=1.2)
text(20, 0.95, "10%", cex=1.2)

########################################################################
                                         
alpha <- seq(0, 1, by=0.05); m=10          # multiple test of hypothesis
p1    <- rep(1, length(alpha)); p2 <- m*(1-alpha)^(m-1)

                                                        # Abbildung 7.22
par(mfrow=c(1,2), lwd=2, font.axis=2.5, bty="n", ps=15) 
plot(alpha, p1, type ="l", ylim=c(0,10), xlim=c(0, 1), las=1,
     ylab=expression(paste("f(",alpha,")")), xlab=expression(alpha))
polygon(c(0,0,0.05,0.05), c(0,1,1,0), density=20)
text(0.5, 5, "Pr(P[1]<=0.05)=0.05)")
plot(alpha, p2, type ="l", ylim=c(0,10), xlim=c(0, 1), las=1,
     ylab=expression(paste("f(",alpha,")")), xlab=expression(alpha))
polygon(c(0,0,0.05,0.05), c(0,10,m*(1-0.05)^(m-1),0), density=20)
text(0.6, 5, "Pr(min(P[i])<=0.05)=0.401")

########################################################################

                                                       # Section 7.5.2

                                                # adjustment of P-values 

test <- 1:5; m <- length(test)                           # example table
p    <- c(0.011, 0.062, 0.015, 0.040, 0.002)
p.B  <- p.adjust(p, method="bonferroni")
R.p  <- rank(p)
p.H  <- p.adjust(p, method="holm")
p.SH <- p.adjust(p, method="hochberg")
p.BH <- p.adjust(p, method="BH")

adjust <- cbind(test, p, p.B, R.p, p.H, p.SH, p.BH); adjust

########################################################################

                                                         # Section 7.5.3

                                              # combinations of P-values
stouffer_test <- function(p, w) {                      # Stouffer method 
  if (missing(w)) w <- rep(1, length(p))/length(p)
  else if (length(w)!=length(p)) stop("p und w different length (?)") 
  zi <- qnorm(1-p); z <- sum(w*zi)/sqrt(sum(w^2))
  P.value <- 1 - pnorm(z)
  cat("z =",z," and combined P-value =",P.value,"\n") }
stouffer_test(p=c(0.04, 0.07, 0.10))

########################################################################

                                                       # Section 7.6.1.3

                                             # multiple samples - ANOVA
x <- c( 9, 11,  6, 11, 14,  7,  7, 11)                  # Bartlett test 
y <- c(13, 10, 12, 16, 11, 13, 15,  9,  9, 10)
z <- c( 7, 27,  8, 11, 17,  2, 16, 15,  9, 15, 18, 12)
k   <- 3
si  <- c(sd(x), sd(y), sd(z)); si
nui <- c(length(x)-1, length(y)-1, length(z)-1); nu <- sum(nui)
c   <- (sum(1/nui)- 1/nu)/(3*(k-1)) +1
ssqr <- sum(nui*si^2)/nu
chisqr <- 1/c*(2.3026 * (nu*log10(ssqr)-sum(nui*log10(si^2)))); chisqr
qchisq(0.95, k-1)
pchisq(chisqr, k-1, lower.tail=F)

bartlett.test(list(x,y,z))

########################################################################

                                                       # Section 7.6.1.4
library(car)
val  <- c(x, y, z)                                         # Levene test    
grp  <- as.factor(c(rep("I", length(x)), 
                    rep("II", length(y)), rep("III", length(z))))
leveneTest(val ~ grp)

########################################################################

fligner.test(val ~ grp)

########################################################################

                                                         # Section 7.6.3
                                                                 
group <- c(1, 1, 2, 2, 2, 2, 3, 3, 3)                    # ANOVA 
value <- c(3, 7, 4, 2, 7, 3, 8, 4, 6)
data  <- data.frame(group=factor(group), value); data
summary(aov(value ~ group, data=data))

########################################################################

group <- c(rep(1,4), rep(2,4), rep(3,4))                 # example
value <- c(6, 7, 6, 5, 5, 6, 4, 5, 7, 8, 5, 8)
data  <- data.frame(group=factor(group), value)
summary(aov(value ~ group, data))

########################################################################

aov_permute <- function(grp, val, B=499) {      # ANOVA permutation test
  grp <- factor(grp)
  n   <- length(val)
  obs <- anova(lm(val ~ grp))$F[1]
  res <- numeric(B)
  for (i in 1:B) {
    index    <- sample(n);     val.perm <- val[index]
    res[i]   <- anova(lm(val.perm ~ grp))$F[1]  }
  p <- (sum(res > obs) + 1) / (B+1)
  cat("ANOVA permutation test P=",p,"\n") }

aov_permute(group, value)

########################################################################

                                                  # sample size an power 
npwr.ANOVA <- function(effect, groups, alpha=0.05, power=NULL, n=NULL) { 
  if (sum(sapply(list(n, power), is.null)) != 1) 
    stop("Error: Only one of power or n may be zero")
  f.distr <- quote({ 
    lambda <- effect^2 * n * groups
    q.alpha <- qf(alpha, groups-1, (n-1)*groups, lower.tail=FALSE)
    pf(q.alpha, groups-1, (n-1)*groups, lambda, lower.tail=FALSE) })
  if (is.null(n)) {
    n <- uniroot(function(n) eval(f.distr)-power, c(2, 1e+05))$root  }
  if (is.null(power)) power <- eval(f.distr)
  cat("Sample size n  =",round(n, 0),"\n",
      "Number of groups   =",groups,"\n",
      "Effect f           =",effect,"\n",
      "Signifikance level =",alpha,"\n",
      "Power              =",round(power*100,2),"%")
}

npwr.ANOVA(effect=0.353, groups=5, alpha=0.05, power=0.80)  

########################################################################

                                                       # Section 7.6.4.1

A <- c(27, 27, 25, 26, 25)     # multiple comparisons according to Tukey
B <- c(26, 25, 26, 25, 24)
C <- c(21, 21, 20, 20, 22)

nA <- length(A); nB <- length(B); nC <- length(C)
f  <- nA + nB + nC - 3
mA <- mean(A);   mB <- mean(B);   mC <- mean(C)
s  <- sqrt((sum((A-mA)^2)+sum((B-mB)^2)+sum((C-mC)^2)) / f)

T.AB <- (mA - mB) / (s*sqrt(0.5*(1/nA + 1/nB))); T.AB
T.AC <- (mA - mC) / (s*sqrt(0.5*(1/nA + 1/nC))); T.AC
T.BC <- (mB - mC) / (s*sqrt(0.5*(1/nB + 1/nC))); T.BC

q    <- qtukey(0.95, 3, f); q 

########################################################################

library(multcomp)
grp <- c(rep("A", nA), rep("B", nB), rep("C", nC))
d   <- data.frame(group = factor(grp), value = c(A, B, C))
model <- aov(value ~ group, data = d);                  # summary(model)
summary(glht(model, linfct = mcp(group = "Tukey")))
confint(glht(model, linfct = mcp(group = "Tukey")))

########################################################################

mA-mB + qtukey(0.95, 3, f)*s*sqrt(0.5*(1/nA + 1/nB))
mA-mB - qtukey(0.95, 3, f)*s*sqrt(0.5*(1/nA + 1/nB))

########################################################################

                                                       # SR distribution
p <- 0.05
k <- 2:12
v <- c(2:40, 50, 60, 70, 80, 90, 100, 10000)
                                                          # Tabelle 7.37
tab <- matrix(data = NA, nrow = 46, ncol = 11, 
              byrow = FALSE, dimnames = NULL)
for (i in 1:46) tab[i,] <- round(qtukey(0.95, k, v[i]),2)
tab <- cbind(v, tab)
tab[1:20,]

########################################################################

                                                       # Section 7.6.4.3

                             # multiple comparisons according to Dunnett
control <- c(7.40, 8.50, 7.20, 8.24, 9.84, 8.32)
prep.A   <- c(9.76, 8.80, 7.68, 9.36)
prep.B   <- c(12.80, 9.68, 12.16, 9.20, 10.55)

n0 <- length(control); nA <- length(prep.A); nB <- length(prep.B)
f  <- n0+nA+nB-(3+1)
m0 <- mean(control);   mA <- mean(prep.A);   mB <- mean(prep.B)
s  <- sqrt((sum((control-m0)^2)+sum((prep.A-mA)^2)+sum((prep.B-mB)^2)) / f)

D.A  <- (mA - m0) / (s*sqrt(1/nA + 1/n0)); D.A
D.B  <- (mB - m0) / (s*sqrt(1/nB + 1/n0)); D.B

R    <- sqrt(nA/(n0+nA)) * sqrt(nB/(n0+nB))
cR   <- matrix(c(1, R, R, 1), nrow=2); round(cR,2)

library(mvtnorm)
qmvt(0.95, tail ="both.tail", df = f, corr = cR)$quantile

########################################################################

library(multcomp)
grp <- c(rep("grp.0", n0), rep("grp.1", nA), rep("grp.2", nB))
d   <- data.frame(group = factor(grp), value = c(control, prep.A, prep.B))
n <- c(n0, nA, nB); names(n) <- paste("Group", c("K", "A", "B"), sep=".")
K <- contrMat(n, type="Dunnett", base=1); K
model <- aov(value ~ group, data = d)
summary(glht(model, linfct = mcp(group = K), alternative = "greater"))

########################################################################

confint(glht(model, linfct = mcp(group = K), alternative = "two.sided"))

########################################################################

                                                       # Section 7.6.4.4

                                # selection of the best according to Hsu

library(mvtnorm)                # quantiles for the Dunnett distribution
qDunnett <-function(p, df, k, tail="both.tails") {                                           
  m    <- k-1                                                     
  R    <- matrix(0.5, m, m)             # Korrelationsmatrix bei gleichen
  for (i in 1:m) R[i, i] <- 1           # Stichprobenumf?ngen
  temp <-qmvt(p, interval=c(0, 7), tail=tail, df=df, corr=R)[1]
  return(temp$quantile)
}

########################################################################
                                                          
library(xtable)                                             # table 7.39
fg <- c(5,7,10,12,14,16,20,24,28,30,40,50,60,80,120,5000) 
rc <- length(fg)
kn <- 2:8
cc <- length(kn)
tab <- matrix(rep(0, rc*cc), nrow=rc, dimnames=list(fg,kn))

for (i in 1:rc) {                              # alpha = 0.10 two-sided
  for (j in 1:cc) tab[i,j] <- qDunnett(0.90, df=fg[i], k=kn[j])   }
xtable(tab, digits=3)

for (i in 1:rc) {                              # alpha = 0.05 two-sided
  for (j in 1:cc) tab[i,j] <- qDunnett(0.95, df=fg[i], k=kn[j])   }
xtable(tab, digits=3)

########################################################################

                                                  # example insect traps
insects <- matrix(c(45, 59, 48, 46, 38, 47, 21, 12, 14, 17, 13, 17,
                   37, 32, 15, 25, 39, 41, 16, 11, 20, 21, 14,  7),
    byrow=F, nrow=6, dimnames=list(1:6,c("yellow","white","red","blue")))
d <- data.frame(insects); attach(d)
caught <- c(yellow, white, red, blue)
color    <- as.factor(c(rep("yellow",6),rep("white",6),
                        rep("red",6),rep("blue",6)))
anova    <- summary(aov(caught ~ color)); anova
MSE      <- anova[[1]][2,3]; MSE

#######################################################################

mi <- apply(insects, 2, mean); mi                       # mean by color
n  <- nrow(insects); k  <- ncol(insects)
MSE  <- 0                                         # compute MSE (error)
for (i in 1:k) {for (j in 1:n) MSE <- MSE + (insects[j,i]-mi[i])^2}
MSE  <- MSE/(k*(n-1))
####### qd   <- qDunnett(0.95, df=k*(n-1), k, tail="lower.tail") ######
qd   <- 2.191
d    <- qd * sqrt(2*MSE/n)             # Distanz mit Dunnett-Quantil                                 
for (i in 1:k) {                       # Beschr?nkte Konfidenzintervalle
  m <- mi[i]; mmax <- max(mi[-i])
  lower.ci <- m - mmax - d; lower.cic <- min(lower.ci, 0)
  upper.ci <- m - mmax + d; upper.cic <- max(upper.ci, 0)
  cat("\n\t", round(lower.cic, 3),"\ - \t",round(upper.cic,3),
      "for", colnames(insects)[i]) }

########################################################################

                                                       # Section 7.6.4.6

                                                       # maximum-modulus 
                                     
                                                            # table 7.41
library(mvtnorm)
fg <- c(5,10,15,20,25,30,40,50,75,100,200,1000); l <- length(fg)
k  <- c(1:10, 15, 20);                           m <- length(k)

tab1 <- matrix(rep(NA, l * m), nrow=l, byrow=T)
for (i in 1:(l-1)) {                       # multivariate t-distribution
    for (j in 1:m) {
tab1[i, j] <- qmvt(0.95, df = fg[i], tail = "both", 
                   corr=diag(k[j]))$quantile               }   }
for (j in 1:m) {                      # multivariate normal distribution 
tab1[l, j] <- qmvnorm(0.95,  mean=rep(0,k[j]), tail = "both", 
                      sigma=diag(k[j]))$quantile               }
tab1 <- cbind(fg, tab1); row <- c(NA, round(k, 0)); 
tab1 <- rbind(row, tab1)
tab1

tab2 <- matrix(rep(NA, l * m), nrow=l, byrow=T)
for (i in 1:(l-1)) {                       # multivariate t-distribution
    for (j in 1:m) {
tab2[i, j] <- qmvt(0.99, df = fg[i], tail = "both", 
                   corr=diag(k[j]))$quantile     }   }
for (j in 1:m) {                      # multivariate normal distribution 
tab2[l, j] <- qmvnorm(0.99,  mean=rep(0,k[j]), tail = "both", 
                      sigma=diag(k[j]))$quantile         }
tab2 <- cbind(fg, tab2); row <- c(NA, round(k, 0)) 
tab2 <- rbind(row, tab2)
tab2

########################################################################
                                                       
grp <- c("A","B","C","D","E","F")                    # example accidents
n.i <- c( 74, 13, 15, 47, 23, 28); N <- sum(n.i)
m.i <- c(14.30, 13.65, 19.57, 16.91, 13.38, 15.89)

mean   <- sum(n.i*m.i)/N;  s  <- 15.26; mean; s

d.i  <- round(m.i - mean, 2); sd.i  <- round(sqrt(s/n.i * (N-n.i)/N), 2)
quot <- round(abs(d.i) / sd.i, 2)
SMM  <- rep(NA, 6); k <- rep(NA, 6) 

tab <- as.data.frame(cbind(grp, n.i, m.i, d.i, sd.i, quot, SMM, k))
names(tab) <- c("Group","Number","Mean","Difference",
                "Stdev.","Ratio","SMM","k")
I <- order(tab$Ratio, decreasing=T); tab <- tab[I, ]      

SMM <- c(2.66, 2.59, 2.51, 2.40, 2.25, 1.97)   # k=6,...,1 | FG=n-6=194
tab[,8] <- 6:1; tab[,7] <- SMM; tab

########################################################################

                                                       # Section 7.6.4.7

                                        # lineare Kontraste nach Scheffe
x <- c( 4,  8, 11, 14, 10,  9, 11,  6); mean(x)     
y <- c(17, 10, 11, 13, 14,  9, 11, 12, 12,  8); mean(y)
z <- c(12, 16, 11, 12, 17, 22, 12, 16, 17, 13, 19, 12); mean(z)

grp    <- c(rep(1,8), rep(2,10), rep(3,12))
wert   <- c(x, y, z)
daten  <- data.frame(grp=factor(grp), wert)
aov.mod  <- aov(wert ~ grp, daten); summary(aov.mod)
se.contrast(aov.mod, list(grp=="1", grp=="2", grp=="3"), coef=c(-1, 0, 1))
library(gmodels)
fit.contrast(aov.mod, grp, c(-1, 0,  1))

########################################################################

                                                         # Section 7.6.5
                                                         
                                                   # Kruskal-Wallis test
                                                                                                           
library(SuppDists)                                          # table 7.43
k <- c(3,4,5,6)
n <- c(3:10, 12, 14, 16, 18, 20, 25, 30, 40, 50, 1000)
alpha <- c(0.10, 0.05, 0.01)

matrix(data = NA, nrow = 1, ncol = 1, byrow = FALSE, dimnames = NULL)
tab     <- matrix(NA, nrow = 20, ncol = 14, byrow = TRUE)
tab[1,] <- c(NA, rep(0.10, 4), rep(0.05,4), rep(0.01, 4), NA)
tab[2,] <- c(NA, rep(c(3,4,5,6), 3), NA)

for (i in 3:20) {
   tab[i,] <- c(n[i-2], 
   round(qKruskalWallis(0.90, k, k*n[i-2], k*(1/n[i-2])), 3),  
   round(qKruskalWallis(0.95, k, k*n[i-2], k*(1/n[i-2])), 3),
   round(qKruskalWallis(0.99, k, k*n[i-2], k*(1/n[i-2])), 3), n[i-2]) }
tab

########################################################################
                                                               
A <- c(12.1, 14.8, 15.3, 11.4, 10.8)                           # example       
B <- c(18.3, 49.6, 10.1, 35.6, 26.2, 8.9)
C <- c(12.7, 25.1, 47.0, 16.3, 30.4)
D <- c( 7.3,  1.9,  5.8, 10.1,  9.4)
x <- c(A, B, C, D)
g <- factor(rep(1:4, c(5, 6, 5,5)),labels = c("A","B","C","D"))
kruskal.test(x, g)

########################################################################

                                                       # Section 7.6.5.1
                                                       
                           # multiple pairwise comparisons of mean ranks
                                                                                                                       
demo <- data.frame(y = c(28, 30, 33, 35, 38, 41,               # example         
                         36, 39, 40, 43, 45, 50,
                         44, 45, 47, 49, 53, 54),
                   group = factor(c(rep("A",6),rep("B",6),rep("C",6))))
library(pgirmess)
kruskalmc(y ~ group, data=demo)

########################################################################

demo <- data.frame(y = c(28, 30, 33, 35, 38, 41,               # example         
                         36, 39, 40, 43, 45, 50,
                         44, 45, 47, 49, 53, 54),
                   group = factor(c(rep("A",6),rep("B",6),rep("C",6))))
library(coin)
kw <- kruskal_test(y ~ group, data = demo,
                   distribution = approximate(B=9999)); kw

########################################################################

library(multcomp)
Nemenyi <- oneway_test(y ~ group, data = demo,
           ytrafo = function(data) trafo(data, numeric_trafo = rank),
           xtrafo = function(data) trafo(data, factor_trafo = function(x)
           model.matrix(~x - 1) %*% t(contrMat(table(x), "Tukey"))),
           teststat = "max")
Nemenyi       
drop(pvalue(Nemenyi, method = "single-step")) 

########################################################################

library(coin)
demo <- data.frame(y = c(28, 30, 33, 35, 38, 41,                      
                         36, 39, 40, 43, 45, 50,
                         44, 45, 47, 49, 53, 54),
                   gruppe = factor(c(rep("A",6),rep("B",6),rep("C",6))))
kw <- kruskal_test(y ~ gruppe, data = demo,
                   distribution = approximate(nresample=9999)); kw

it <- independence_test(y ~ gruppe, data = demo,
        distribution = approximate(nresample = 50000),
        ytrafo = function(data) trafo(data, numeric_trafo = rank_trafo),
        xtrafo = function(data) trafo(data, factor_trafo = function(x)
        model.matrix(~x - 1) %*% t(contrMat(table(x), "Tukey")))); it

pvalue(it, method = "single-step")

########################################################################

                                                       # Section 7.6.5.4
          
jonckheere.test<-function(x, g)  {            # Jonckheere-Terpstra test
    x <- table(g,x); nco <- ncol(x);  nro <- nrow(x);  summe <- 0
    for(j in 1:(nco - 1))
      for(i in 1:(nro - 1))
       summe <- summe + x[i, j] * (0.5 * sum(x[(i + 1):nro, j]) + 
                                         sum(x[(i + 1):nro, (j + 1):nco]))
    for(k in 1:(nro - 1))
        summe <- summe + x[k, nco] * 0.5 * sum(x[(k + 1):nro, nco])
    n   <- sum(x);     nip <- apply(x, 1, sum);    npj <- apply(x, 2, sum)
    expect <- (n^2 - sum(nip^2))/4
    u1 <- n * (n - 1) * (2 * n + 5) - sum(nip * (nip - 1) * (2 * nip + 5)) - 
                                      sum(npj * (npj - 1) * (2 * npj + 5))
    u2 <- sum(nip * (nip - 1) * (nip - 2)) * sum(npj * (npj - 1) * (npj - 2))
    u3 <- sum(nip * (nip - 1)) * sum(npj * (npj - 1))
    v  <- u1/72 + u2/(36 * n * (n - 1) * (n - 2)) + u3/(8 * n * (n - 1))
    zval <- (summe - expect)/sqrt(v);     pval <-1 - pnorm(zval)
    cat("Jonckheere-Terpstra test : ", " statistic =",
                               round(zval, 3)," P =",round(pval, 3),"\n")
}

########################################################################
                                                             
A <- c(30, 31, 34, 34, 37, 39)                               # example 1
B <- c(36, 38, 41, 41, 45, 48)
C <- c(44, 45, 47, 49, 50, 50)
value <- c(A, B, C);   n <- c(6, 6, 6)
grp   <- as.ordered(factor(rep(1:length(n),n)))
jonckheere.test(value, grp)

########################################################################
                                                            
A <- c(106, 114, 116, 127, 145)                              # example 2
B <- c(110, 125, 143, 148, 151)
C <- c(136, 139, 149, 160, 174)
value <- c(A, B, C);  n <- c(5, 5, 5)
grp   <- as.ordered(factor(rep(1:length(n),n)))
jonckheere.test(value, grp)

########################################################################

library(coin)
oneway_test(value ~ grp, scores = list(grp = c(1, 2, 3)))

########################################################################

                                                         # Section 7.6.6
                                                         
                         # analysis of variances - repeated measurements
                                                                                                               
diet <- data.frame(effect = c(1.5, 1.4, 1.4, 1.2, 1.4,   # example diets
                              2.7, 2.9, 2.1, 3.0, 3.3,
                              2.1, 2.2, 2.4, 2.0, 2.5,
                              1.3, 1.0, 1.1, 1.3, 1.5),
patient = factor(paste("pat", rep(1:5, 4), sep="")),
zeit = factor(paste("T", rep(c(1, 2, 3, 4), c(5, 5, 5, 5)), sep="")),
row.names = NULL); diet
summary(aov(effect ~ zeit + Error(patient), data=diet))

########################################################################

                                                         # Section 7.6.7
                                                         
                                                         # Friedman test  
                                                                                                                       
library(SuppDists)                                       # table 7.46   
k <- c(3,4,5,6)
n <- c(3:10, 12, 14, 16, 18, 20, 25, 30, 35, 40, 45, 
                                50, 60, 70, 80, 90, 100, 1000)
alpha <- c(0.05, 0.01)

tab <- matrix(NA, nrow = 27, ncol = 10, byrow = TRUE)
tab[1,] <- c(NA, rep(0.05,4), rep(0.01, 4), NA)
tab[2,] <- c(NA, rep(c(3,4,5,6), 2), NA)

for (i in 3:27) {
   tab[i,] <- c(n[i-2], round(qFriedman(0.95, k, n[i-2]), 3),
                        round(qFriedman(0.99, k, n[i-2]), 3), n[i-2]) }
tab

#######################################################################
                                                  
y <- matrix(c( 2.2, 2.0, 1.8,                       # example chocolate
               2.4, 1.8, 1.6,
               2.5, 1.9, 1.7,
               1.7, 2.5, 1.9),
            nrow = 4, byrow = TRUE,
            dimnames = list(person = as.character(1:4),
                            type = LETTERS[1:3])); y
n <- dim(y)[1];    k <- dim(y)[2]
R <- matrix(rep(NA, n*k), nrow=n, byrow=TRUE)          # ranks
for (i in 1:n) R[i,] <- rank(-y[i,]); R
Ri2 <- colSums(R)^2; Ri2
stat <- (12/(n*k*(k+1)))*sum(Ri2) - 3*n*(k+1); stat    # test statistic
pval <- 1 - pchisq(stat, k-1); pval
friedman.test(y)                     # friedman.test() in library(stats)

########################################################################

                                                     # example chocolate
y <- data.frame(preis = c(2.20, 2.40, 2.50, 1.70,
                          2.00, 1.80, 1.90, 1.60,
                          1.80, 1.60, 1.70, 1.90),
            subj  = factor(paste("p", rep(1:4, 3), sep="")),
            sorte = factor(paste("t", rep(c(1, 2, 3), c(4, 4, 4)), sep="")),
            row.names = NULL); y
friedman.test(preis ~ sorte | subj, data=y)                 # model form

########################################################################

                                                       # Section 7.6.7.2

                 # multiple comparisons according to Wilcoxon and Wilcox

                                                             # diuretics
diuret <- data.frame(block = factor(rep(1:6, rep(6,6))),
               diuretic = factor(rep(c("A","B","C","D", "E","F"), 6)),
               sodium = c(3.88, 30.58, 25.24, 4.44, 29.41, 38.87, 
                           5.64, 30.14, 33.52, 7.94, 30.72, 33.12,
                           5.76, 16.92, 25.45, 4.04, 32.92, 39.15,
                           4.25, 23.19, 18.85, 4.40, 28.23, 28.06,
                           5.91, 26.74, 20.45, 4.23, 23.35, 38.23,
                           4.33, 10.91, 26.67, 4.36, 12.00, 26.65))
reshape(diuret, timevar="diuretic", idvar="block", direction="wide")

friedman_test(sodium ~ diuretic | block, data = diuret)

library(coin)                           # multiple pairwise omparisons
library(multcomp)                       # Friedman test
friedm <- symmetry_test(sodium ~ diuretic | block, data = diuret,
       xtrafo = function(data) trafo(data, factor_trafo = function(x)
                model.matrix(~ x - 1) %*% t(contrMat(table(x), "Tukey"))),
       ytrafo = function(data) trafo(data, numeric_trafo = rank_trafo, 
                                          block = diuret$block),
       teststat = "max",
      )

pvalue(friedm)                                         

drop(round(pvalue(friedm, method = "single-step"), 5))

########################################################################

                                                           # figure 7.23
par(mfcol=c(1,1), lwd=3, font.axis=2, bty="l", ps=15) 
matplot(t(matrix(diuret$sodium, ncol = 6, byrow = TRUE)), 
          type = "l", col = 1, lty = 1, axes = FALSE, lwd=1.3,
          ylab = "Sodium excretion", xlim = c(0.5, 6.5))
axis(1, at = 1:6, labels = levels(diuret$diuretic)); axis(2) 

########################################################################

                                                       # Section 7.6.7.3
                                                         
                                                             # Page-Test
                                                     
library(crank)                                       # example reviewers
reviewer <- matrix(c(2,2,1,2,2,1,3,1,1,              # object B           
                      1,3,2,3,1,2,2,2,4,             # object C           
                      4,1,3,1,4,3,1,4,2,             # object D           
                      3,4,4,4,3,4,4,3,3),            # object A           
                      nrow=9,byrow=F)
Page <- page.trend.test(reviewer, ranks=TRUE); Page

########################################################################

g <- data.frame(block = factor(rep(1:9, rep(4,9))),
               objekt = ordered(rep(c("Obj1","Obj2","Obj3","Obj4"), 9)),
               note = c(2,1,4,3,     2,3,1,4,       1,2,3,4,
                        2,3,1,4,     2,1,4,3,       1,2,3,4,
                        3,2,1,4,     1,2,4,3,       1,4,2,3))      
library(coin)
friedman_test(note ~ objekt | block, data = g)

########################################################################

                                                       # Section 7.6.7.4
y <- matrix(c( 5, 4, 7, 10, 12, 1, 3, 1, 0, 2,
               16, 12, 22, 22, 35, 5, 4, 3, 5, 4,
               10, 9, 7, 13, 10, 19, 18, 28, 37, 58,
               10, 7, 6, 8, 7),
            nrow = 7, byrow = TRUE,
            dimnames = list(Store = as.character(1:7),
                            Brand = LETTERS[1:5]))
k <- dim(y)[1];    b <- dim(y)[2]                     # Quade test
R <- matrix(rep(NA,k*b), nrow=k, byrow=TRUE)          # rank numbers
for (i in 1:k) R[i,] <- rank(y[i,]); R
range  <- rep(NA, k)                                  # ranges 
for (i in 1:k) range[i] <- max(y[i,]) - min(y[i,])
Qi <- rank(range)
                                                      
S  <- Qi * (R - (b + 1)/2)                            # scores
A2 <- sum(S^2)                                        # Q total
B  <- sum(colSums(S)^2)/k                             # Q between                
stat <- (k-1)*B / (A2-B); stat                        # test statistic
pval <- 1 - pf(stat, b-1, (b-1)*(k-1)); pval

########################################################################

quade.test(y)                           # quade.test() in library(stats)
library(PMCMRplus)                      # multiple pairwise comparisons
quadeAllPairsTest(y, dist="TDist", p.adj="none")

########################################################################

                                                         # Section 7.6.8
                                                         
                                          # two-way analysis of variance
                                                                                                 
depr <- data.frame(                             # example antidepressant
score = c(22, 25, 22, 21, 22, 16, 16, 16, 15, 15, 13, 12, 12, 13, 12,
          18, 19, 17, 21, 19, 19, 20, 17, 16, 16, 16, 14, 16, 13, 14),
gender  = factor(c(rep("Man", 15), rep("Woman",15))),
therapy = factor(rep(c(rep("placebo",5),rep("simple",5),
                      rep("double",5)),2))); depr[1:5,]
summary(aov(score ~ therapy + gender + gender:therapy, depr))

########################################################################

                                                           # figure 7.25
par(mfrow=c(1,1), lwd=2, font.axis=2, bty="l", ps=14)
depr$therapy <- relevel(depr$therapy, "double")
interaction.plot(depr$therapy, depr$gender, depr$score, main=" ",
                 trace.label="Gender", lwd=3,  xlab=" ", las=1, 
                 ylab="Depression (Score)")

########################################################################

                                                       # Abschnitt 7.6.9
                                                         
                                                    
Time <- c(5, 10, 15, 20, 25, 30, 35, 40)         # repeated measurements
y1   <- c(5,  7, 10, 15, 14, 12,  8,  6)
y2   <- c(5,  6,  8, 11, 15, 18, 21, 23)

                                                           # figure 7.26
par(mfrow=c(1,2), lwd=1.8, font.axis=2, bty="n", ps=15) 
plot(Time, y1, type="b", ylab="Measurements (Y)", las=1, lwd=2,
     ylim=c(0,25), xlim=c(0,40))
abline(h=5, lty=3, col="grey")
text(10, 23, "A", cex=2)
plot(Time, y2, type="b", ylab="Measurements (Y)", las=1, lwd=2,
     ylim=c(0,25), xlim=c(0,40))
text(10, 23, "B", cex=2)
abline(h=5, lty=3, col="grey")
abline(h=25, lty=3, col="grey")

########################################################################

                                                               # example                                                 
data  <- read.table("repeated-01.csv", 
      header=TRUE, sep=";", na.strings="NA", dec=",", strip.white=TRUE)
attach(data)
Time  <- c(0, 5, 10, 20, 30, 60)
                                                           # figure 7.27
par(mfrow=c(1,2), lwd=1.7, font.axis=2, bty="n", ps=15)
plot(Time, data[1,3:8], type="b", las=1, lwd=1.8,
     ylab="Measurement", main=" ", ylim=c(5,20))
text(30, 20, "Group A")
for (i in 2:5) lines(Time, data[i, 3:8], type="b")
plot(Time, data[6,3:8], type="b", las=1,lwd=1.8,
     ylab="Measurement", main="", ylim=c(5,20), lty=2)
text(30, 20, "Group B")
for (i in 7:10) lines(Time, data[i, 3:8], type="b", lty=2)          

########################################################################

AUC   <- function(y, t, n) {                    # area under curve       
         F <- rep(NA, (n-1))                     
         for (i in 1:(n-1)) F[i] <- (t[i+1]-t[i])*(y[i]+y[i+1])
         sum(F)/2          }
REGR <- function(y, t, n) {                     # regression coefficient
sum((y-mean(y))*(t-mean(t)))/sum((t-mean(t))^2)     }
data  <- read.table("repeated-01.csv", 
          header=TRUE, sep=";", na.strings="NA", dec=",", strip.white=TRUE)
attach(data)
Time <- c(0, 5, 10, 20, 30, 60)
                                                     # table for example
data$Max   <- apply(data[,3:8], 1, max, na.rm = T)        # maximum   
data$AUC   <- apply(data[,3:8], 1, AUC,  t=Time, n=6)     # AUC       
data$REGR  <- apply(data[,5:8], 1, REGR, t=Time[3:6], n=4)# regression
data

t1  <- t.test(Max ~ group, data = data)                   # maximum     
max <- c(t1$estimate,t1$statistic,t1$p.value)
t2  <- t.test(AUC ~ group, data = data)                   # AUC         
auc <- c(t2$estimate,t2$statistic,t2$p.value)
t3  <- t.test(REGR ~ group, data = data)                  # change   
reg <- c(t3$estimate,t3$statistic,t3$p.value)
t4  <- t.test(t60 ~ group, data = data)                # last value
lst <- c(t4$estimate,t4$statistic,t4$p.value)
tab <- as.data.frame(rbind(max,auc,reg,lst), row.names = c("Max",
       "AUC","REGR","t60")); tab

########################################################################

                                                       # Section 7.6.9.2

                                           # repeated measurements ANOVA 
                                           # reshape data 
neu  <- reshape(data, varying=list(c("t0","t5","t10","t20","t30","t60")),
         v.names=c("value"), timevar="time", 
         times=c(0, 5, 10, 20, 30, 60), idvar="prob", direction="long")
                                                       
rep.aov <- aov(neu$value ~ factor(neu$group)*factor(neu$time) 
                                       + Error(factor(neu$prob)))
summary(rep.aov)

par(mfrow=c(1,1), lwd=1.7, font.axis=2, bty="l", ps=12)
interaction.plot(neu$time, factor(neu$group), neu$value, lty=c(1,12), lwd=3, 
                 ylim=c(0,20), ylab="Mean", xlab="Zeit", trace.label="Group")

########################################################################

                                                        # Section 7.6.10
                                                         
                                                   # experimental design

Amm     <- c(rep(0,4),rep(1,4),rep(0,4),rep(1,4),rep(0,4),rep(1,4),rep(0,4),rep(1,4))
Magn    <- c(rep(0,8),rep(1,8),rep(0,8),rep(1,8))
Manure  <- c(rep(0,16),rep(1,16))
yield <- c(19.2,15.5,17.0,11.7,20.6,16.9,19.5,21.9,18.9,20.2,16.7,
           20.7,25.3,27.6,29.1,25.4,20.8,18.5,20.1,19.2,26.8,17.8, 
           18.6,19.0,22.2,18.6,22.3,21.1,27.7,28.6,28.7,28.5)
data <- data.frame(block=gl(8,4), Amm=factor(Amm), 
          Magn=factor(Magn), Manure=factor(Manure), yield=yield)
yield.aov1 <- aov(yield ~ block, data)
summary(yield.aov1)             

yield.aov2 <- aov(yield ~ Amm*Magn*Manure, data)
summary(yield.aov2)
 

########################################################################

                                                           # Section 7.7

                                                           # frequencies
       
n.obama <- 120; n.mccain <- 80; n.other <- 10            # USA elections
data <- c(rep("Obama",n.obama), rep("McCain", n.mccain), 
          rep("andere",n.other))
bootstrap.stat <- function(data) {                           # bootstrap
    b.smpl <- sample(data, length(data), replace=TRUE)
    (sum(b.smpl=="Obama") - sum(b.smpl=="McCain"))/length(data) }
p.distr <- replicate(500, bootstrap.stat(data))
round(quantile(p.distr, probs=c(0.025, 0.25, 0.50, 0.75, 0.975)), 4) 

########################################################################

                                                        # biodiversities
food      <- c("Oak","Corn","Blackberry","Beech","Cherry","Others")
michigan  <- c(47, 35,  7,  5, 3, 2)
louisiana <- c(48, 23, 11, 13, 8, 2) 
jay.diet  <- as.data.frame(cbind(food, michigan, louisiana)); jay.diet

shannon.index <- function(x) {
  n <- sum(x); k <- length(x)
  (n*log10(n) - sum(x*log10(x)))/n
}
H.1 <- shannon.index(michigan); H.1
H.2 <- shannon.index(louisiana); H.2

shannon.test <- function(x, y, alpha) {
  sign <- 1 - alpha/2
  nx  <- sum(x); kx <- length(x)
  ny  <- sum(y); kx <- length(y)
  Hx  <- (nx*log10(nx) - sum(x*log10(x)))/nx        # Shannon index 1
  Hy  <- (ny*log10(ny) - sum(y*log10(y)))/ny        # Shannon index 2
  s2x <- (sum(x*log10(x)^2) - (sum(x*log10(x)))^2/nx)/nx^2
  s2y <- (sum(y*log10(y)^2) - (sum(y*log10(y)))^2/ny)/ny^2
  stat <- abs((Hx - Hy) / sqrt(s2x + s2y))          # test statistic
  fg   <- round(nx*ny*(s2x+s2y)^2 / (ny*s2x^2 + nx*s2y^2), 0)
  p.val <- (1 - pt(stat, fg))*2                     # P-vaule two-sided
  cat(" Shannon-Wiener index in population X =", round(Hx, 4),
      "and in population y =", round(Hy, 4),"\n",
      "Test statistic:", round(stat, 4),
      "t-distribution with",fg,"degrees of freedom:",
      round(qt(sign, fg), 4),"- P-value", round(p.val, 4),"\n")   }
shannon.test(michigan, louisiana, alpha=0.05)

########################################################################

                                                         # Section 7.7.2
                                                         
                                                       # fourfold tables

tab <- matrix(c(15, 85, 4, 77), nrow=2, ncol=2, byrow=TRUE)
dimnames(tab) <- list(c("usual therapy","new therapy"), 
                      c("died","healed")); tab
chisq.test(tab, correct=FALSE)

chisq.test(tab, correct=TRUE)

mosaicplot(tab, col=TRUE, main=" ")

########################################################################

                                                       # Section 7.7.2.1
                                                       
                                                 # sample size and power
z.alpha <- qnorm(0.975); z.beta  <- qnorm(0.90)
p1 <- 0.38;       q1 <- 1 - p1
p2 <- 0.30;       q2 <- 1 - p2
p <- (p1 + p2)/2; q <- 1 - p
n <- (z.alpha * sqrt(2*p*q) + z.beta * 
          sqrt(p1*q1+p2*q2))^2 / ((p2 - p1)^2); n

########################################################################

power.prop.test(p1=0.3,p2=0.38, sig.level =0.05, power = 0.90)

########################################################################

library(pwr)
effect <- ES.h(0.38, 0.30); effect
p2p    <- pwr.2p.test(h = effect, sig.level = 0.05, power = 0.90); p2p
plot(p2p)
                                                           # figure 7.30
par(mfrow=c(1,1), lwd=2, font.axis=2.5, bty="n", ps=15) 
d <-power.prop.test(n= seq(400, 800, by=20), p1=0.3, p2=0.38, sig.level =0.05)
plot (d$n, d$power, type="b", xlab="Sample size (each group)", las=1, cex=0.8,
        ylab="Power", ylim=c(0.6, 1.0), xlim=c(400, 800), xaxp=c(400,800,8) ) 
abline(h=seq(0.6, 1.0, 0.05), lty=3, col="grey")
abline(v=seq(400, 800, 50), lty=3, col="grey")

########################################################################

                                                         # Section 7.7.3
                                                                                                        
a <- 24; b <- 96; c <- 48; d <- 592         # cohort study result                  
tab <- matrix(c(a, b, c, d), nrow=2, ncol=2, byrow=TRUE)
dimnames(tab) <- list(c("exposed","not exposed"), 
                      c("diseased","not diseased")); tab
IR.exp  <- a / (a+b); IR.exp                # incidence rate exposed      
IR.nexp <- c / (c+d); IR.nexp               # incidence rate not exposed
delta   <- IR.exp - IR.nexp; delta          # attributable risk       
psi     <- IR.exp / IR.nexp; psi            # relative risk            
omega   <- (a*d) / (b*c); omega             # odds ratio                  

########################################################################

                                                       # Section 7.7.3.2

library(vcd)                                      # confidence intervals
tab <- matrix(c(a, b, c, d), nrow=2, ncol=2, byrow=TRUE)
dimnames(tab) <- list(c("exposed","not exposed"), 
                      c("diseased","not diseased")); tab
OR <- oddsratio(tab, log=FALSE); summary(OR);  confint(OR)

                                                           # figure 7.31
library(Hmisc)
sor <- summary(OR); cor <- confint(OR)             # confidence interval
par(mfrow=c(1,2), lwd=2, font.axis=2.5, bty="n", ps=19) 
mosaicplot(tab, col=TRUE, main=" ")
u <- cor[1]; v <- sor[1]; o <- cor[2]
errbar(x=1, v, o, u , xlim=c(0.9, 1.1), ylim=c(1,6), las=1, xaxt="n",
        cex=3, lwd=2.5, xlab=" ", ylab="Odds Ratio (95%-CI)")
abline(h=1, lty=2, col="grey")

########################################################################

                                                       # Section 7.7.3.3

                                    # sample size with multiple controls
smpl.matched.cc <- function(alpha, beta, MM, OR, ff) {
    zalpha <- qnorm(alpha/2, lower.tail = FALSE)
    zbeta  <- qnorm(beta, lower.tail=FALSE)
    ss <- (OR-1)*ff*(1-ff)/((1-ff)+ ff*OR)
    nn <- (MM+1)*((zalpha*(1+OR) + 2*zbeta*sqrt(OR))^2)/(2*MM*(OR^2 - 1)*ss)
    round(nn, 0)
}
smpl.matched.cc(alpha=0.05, beta=0.10, 1:4, OR=1.5, ff=0.1)

########################################################################

result <- matrix(NA, nrow=6, ncol=5)                        # table 7.66
or     <- c(1.5,2,2.5,3,3.5,4)
for (i in 1:length(or)) 
result[i, ] <- c(or[i], smpl.matched.cc(0.05, 0.10, 1:4, or[i], 0.1))
result

########################################################################

                    # sample size and power for estimating relative risk
npwr.RR <- function(P2, RR, N=NULL, alpha=0.05, power=NULL, 
                    einseitig=TRUE, r=1) {
  if (sum(sapply(list(N, power), is.null)) != 1) 
    stop("Either 'N' or 'Power' must be set to NULL!")
  if (einseitig) zalph <- qnorm(1-alpha) else zalph <- qnorm(1-alpha/2) 
  p.c   <- (P2*(r*RR+1))/(r+1)  
  if (is.null(N)) {
    N     <- (r+1)/(r*(RR-1)^2*P2^2) * (zalph*sqrt((r+1)*p.c*(1-p.c)) 
              + qnorm(power) * sqrt(RR*P2*(1-RR*P2)+r*P2*(1-P2)))^2  }
  if (is.null(power)) {
    zpower <- (P2*abs(RR-1)*sqrt(N*r) - zalph*(r+1)*sqrt(p.c*(1-p.c))) /
      sqrt((r+1)*(RR*P2*(1-RR*P2)+r*P2*(1-P2))) 
    power <- pnorm(zpower)  }
  cat("Sample size and power for the relative risk","\n",
      "Sample size N:",round(N, 0),"\n", 
      "Power        :",round(power,5),"\n")
}    
npwr.RR(P2=0.2, RR=2.0, alpha=0.05, einseitig=TRUE, power=0.90)
npwr.RR(P2=0.2, RR=2.0, alpha=0.05, einseitig=TRUE, N=176)

########################################################################

                                                       # Section 7.7.3.4
                                                     
a    <- 72; b <- 684                                  # Framingham study
c    <- 20; d <- 553; N <- a+b+c+d
RR   <- ( a*c + a*d ) / ( a*c + b*c ) ; RR
Pexp <- ( a + b ) / N ; Pexp
PAR  <- Pexp * (RR - 1) / (1 + Pexp * (RR - 1)); PAR
var  <- ( c*N*( a*d*(N-c ) + b*c^2) ) / ( ( a+c )^3 * ( c+d )^3 )
se   <- sqrt(var)
KIu  <- PAR - 1.96*se; KIo <- PAR + 1.96*se; KIu; KIo

########################################################################

                                                         # Section 7.7.4

                                                     # exact Fisher test 

                                                     # tea tasting lady                                                     
TeaTasting <- matrix(c(3, 1, 1, 3),  nr = 2,         
       dimnames = list(Guess = c("Milk", "Tea"), Truth = c("Milk", "Tea")))
addmargins(TeaTasting)
fisher.test(TeaTasting, alternative = "greater")

                                                     # numeric example 
tab <- matrix(c(2, 8, 10, 4), byrow=TRUE, nr = 2); tab
fisher.test(tab, alternative="less", conf.level=0.95)


########################################################################

                                                         # Section 7.7.5

                              # equivalence of to binomial probabilities

                                              # intervall inklusion test
TOST_int <- function(r1, n1, r2, n2, delta, alpha) { 
            level <- (1-2*alpha)*100
            p1 <- r1/n1; p2 <- r2/n2;  z  <- qnorm(1-2*alpha)
            d  <- p1*(1-p1)/n1 + p2*(1-p2)/n2 + ((1/n1)+(1/n2))/2
            lu <- p1 - p2 - z * sqrt(d);     lo <- p1 - p2 + z * sqrt(d)
cat("The",level,"%-CI for the difference",p1-p2,"is",
    round(lu, 3),"to",round(lo, 3),"\n",
    "with reference to the equivalence interval",-delta,"to",+delta,"\n") } 
           
                                         # according to Dunnett und Gent
TOST_test <- function(r1, n1, r2, n2, delta) { 
             p1 <- r1/n1; p2 <- r2/n2 
             p1d <- (r1 + r2 + delta*n2)/(n1+n2); p2d <- p1d - delta
             z1 <- (p1 -p2 - delta)/sqrt((p1d*(1-p1d)/n1)+(p2d*(1-p2d))/n2)
             p1d <- (r1 + r2 - delta*n2)/(n1+n2); p2d <- p1d + delta
             z2 <- (p1 -p2 + delta)/sqrt((p1d*(1-p1d)/n1)+(p2d*(1-p2d))/n2)
             P <- pnorm(z1) + (1-pnorm(z2))
cat("The P-value for the two-sided test for equivalence of",p1,"versus",p2,"\n",
    "with delta =",delta,"ist P=",P,"\n")  }

TOST_int(120, 200, 57, 100, 0.15, 0.05)      # example equivalence study

TOST_test(120, 200, 57, 100, 0.15)                             

########################################################################

                                             # example study planning
alpha <- 0.05;  beta  <- 0.20; p1 <- 0.58; p2 <- 0.60; delta <- 0.15
n <- ((qnorm(1-alpha) + qnorm(1-beta))^2 * 
                       (p1*(1-p1) + p2*(1-p2))) / (delta-(p1-p2))^2; n

########################################################################

                                                         # Section 7.7.6

                                                          # McNemar test 

                                             # empty or sham preparation
wirk <- matrix(c(8, 16, 5,11), nr=2, byrow=TRUE,
        dimnames = list(verum=c("strong","weak"), placebo=c("strong","weak")))
wirk; mcnemar.test(wirk, correct=TRUE)

########################################################################

discordant <- c(wirk[1,2], wirk[2,1])              # discordant results
nd         <- sum(discordant)
x          <- min(discordant)
pbinom(x, nd, 0.5)                  # binomial probability (exact)
binom.test(x, nd, p=0.5)            # binomial test (conditionally ...)

########################################################################

library(exact2x2)                   # see also in library(exact2x2)
mcnemar.exact(wirk)

########################################################################

library(binom)                                               # holidays
holiday <- matrix(c(71, 3, 16, 10), nrow=2, byrow=TRUE, 
          dimnames = list(c("+","-"), c("+","-"))); holiday
mcnemar.test(holiday)
binom.confint(3, 19, method="exact")

########################################################################
                 
                            # sample size and power for the McNemar test 
npwr.mcnemar <- function(p, psi, alpha=0.05, n=NULL, power=NULL) {
  if (sum(sapply(list(n, power), is.null)) != 1) 
    stop("exactly one of 'n' or 'power' must be NULL")
  zalpha <- qnorm(1-alpha/2)
  if (is.null(n)) {
    zbeta <- qnorm(power)
    n <- (zalpha*sqrt(psi+1) + zbeta*sqrt((psi+1) - (psi-1)^2*p))^2 / 
      (p*(psi-1)^2)   }
  if (is.null(power)) {
    zbeta <- (sqrt(n)*sqrt(p)*(psi-1) - qnorm(1-alpha/2)*sqrt(psi + 1)) / 
      sqrt((psi + 1) - p * (psi - 1)^2)
    power <- pnorm(zbeta)    }
  cat("Sample size and power for the McNemar test","\n",
      "Sample size:",ceiling(n),"\n", 
      "Power      :",round(power,5),"\n")
}

npwr.mcnemar(p=0.125, psi=3.2, n=40)
npwr.mcnemar(p=0.125, psi=2.0, power=0.90)

########################################################################

                                                         # Section 7.7.7

                                                  # Mantel-Haenszel test
MH.test <- function(tab, conf.level=0.95, correct=T) {
##### 3-dim. table tab[2,2,k]: 1-exposure / 2-disease / 3-stratum #####
  zquant <- qnorm(conf.level)                   # significance level
  cval   <- ifelse(correct==T, 0.5, 0)          # continuity correction
  si <- dim(tab)[3]; OR <- V <- E <- w <- S <- numeric(si)
  for (i in 1:si) {                             # OR - per stratum
    OR[i] <- (tab[1,1,i]*tab[2,2,i]) / (tab[1,2,i]*tab[2,1,i]) 
    E[i]  <-  colSums(tab[,,i])[1] * rowSums(tab[,,i])[1] / sum(tab[,,i]) 
    V[i]  <- (colSums(tab[,,i])[1] * colSums(tab[,,i])[2] * rowSums(tab[,,i])[1] 
              * rowSums(tab[,,i])[2]) / (sum(tab[,,i])^2 * (sum(tab[,,i]) - 1))
    w[i]  <- (tab[1,2,i] * tab[2,1,i]) / sum(tab[,,i])  }  
  ORmh  <- sum(w*OR)/sum(w)          #   Mantel-Haenszel Odds-Ratio test
  CHImh <- (sum(tab[1,1,]) - sum(E) - cval)^2 / sum(V)
  pval1 <- pchisq(CHImh, df=1, lower.tail=F)
  cio   <- ORmh**(1 + 1.96/sqrt(CHImh)); ciu   <- ORmh**(1 - 1.96/sqrt(CHImh))
                                # test effect modification - confounding
  for (i in 1:si) S[i] <- (tab[1,1,i]*tab[2,2,i] - 
                        ORmh*tab[1,2,i]*tab[2,1,i])^2 / (ORmh*V[i]*sum(tab[,,i])^2)
  CHIefm  <- sum(S); pval2 <- pchisq(CHIefm, df=1, lower.tail=F)
  
  cat("\n","*** Mantel-Haenszel test (Effect modification/confounding) ***","\n",
      "Odds-Ratio in Strata:", round(OR, 2),"\n",
      "  Mantel-Haenszel OR:", round(ORmh, 2),"\n",
      "       Chiquadrat-MH:", round(CHImh, 4),"(P \b= \b",round(pval1, 5),"\b)","\n",
      " Confidence interval:", round(ciu,2),"-",round(cio,2),"\n",
      "    Chisquare effect:", round(CHIefm, 4),"(P \b= \b",round(pval2, 5),"\b)","\n")  }

########################################################################

                                                              # example
tab <- array(c(15, 4, 85, 77, 20, 7, 56, 51), dim = c(2, 2, 2),
             dimnames = list( K = c("I", "II"),  E = c("+", "-"),
                              Gender = c("male", "female")))
MH.test(tab, conf.level=0.95, correct=T)

########################################################################

mantelhaen.test(tab, correct = T, conf.level = 0.95)

########################################################################

                                                       # Section 7.7.7.1
                                                
breslow.day.test <- function(x, OR=NA) {       # Breslow and Day test  
    if(is.na(OR)) {                            # OR - Mantel-Haenszel
        OR = mantelhaen.test(x)$estimate;  names(OR) = ""   }                                              
  k <- dim(x)[3]                               # Strata          
  a <- hat.a <- Var.a <- numeric(k)                
  X2.stat <- 0
  for (j in 1:k) {                             # marginal sums          
    mj <- apply(x[,,j], MARGIN=1, sum)
    nj <- apply(x[,,j], MARGIN=2, sum)
                                               # estimation aj   
    coef <- c(-mj[1]*nj[1]*OR, nj[2]-mj[1]+OR*(nj[1]+mj[1]), 1-OR)
    sols <- Re(polyroot(coef))         # 0 < hat.aj <= min(n1_j, m1_j)   
    hat.aj <- sols[(0 < sols) &  (sols <= min(nj[1],mj[1]))]
                                                             
    hat.bj <- mj[1]-hat.aj                     # other estimates
    hat.cj <- nj[1]-hat.aj
    hat.dj <- mj[2]-hat.cj
    Var.aj <- (1/hat.aj + 1/hat.bj + 1/hat.cj + 1/hat.dj)^(-1)
    aj <- x[1,1,j]                             # observed frequancies       
                                               # test statistic    
    X2.stat <- X2.stat + as.numeric((aj - hat.aj)^2 / Var.aj)
    a[j] <- aj;  hat.a[j] <- hat.aj; Var.a[j] <- Var.aj
  }
                                               # Tarrone correction         
  X2.stat <-as.numeric(X2.stat - (sum(a) - sum(hat.a))^2/sum(Var.a)) 
  p <- 1-pchisq(X2.stat, df=k-1)
  return(unlist(list(OR = round(OR, 3), Statistic = round(X2.stat, 3),
         df = round(k-1, 0), P.Wert = round(p,6))))     }

alcohol <- array(c(1,0,9,106,4,5,26,164,25,21,29,138,
                                     42,34,27,139,19,36,18,88,5,8,0,31),
           dim=c(2,2,6), dimnames=list(c("exposed","not exposed"),
           c("case","control"),
           c("25-34","35-44","45-54","55-64","65-74",">74")))
mantelhaen.test(alcohol, alternative="two.sided", correct=TRUE)   
breslow.day.test(alcohol, OR=NA) 
breslow.day.test(alcohol, OR=2)                               # H0: OR=2

########################################################################

                                                         # Section 7.7.8

                                                  # Brandt-Snedecor test
success <- matrix(c(14, 22, 18, 16, 8, 2), nr=3, byrow=T,
          dimnames = list(healing=c("healed-x","healed-x+y","died"),
          therapy=c("symptomatic","specific"))); success
chisq.test(success, correct = TRUE)

########################################################################

                                                     # Abschnitt 7.7.8.1

                                                  # Marascuilo procedure
marascuilo.procedure <- function(x, n, alpha=0.05) {
  p <- x/n; k <- length(p); m <- 1
  chiq <- qchisq(1-alpha, df=k-1)
  dif <- matrix(rep(NA, 4*((k*(k-1)/2))), nrow=4, byrow=T)
  row.names(dif) <- c("i","j","Difference","crit. Value")
  for (i in 1:(k-1)) {
      for (j in (i+1):k) {
        dif[1, m] <- i; dif[2, m] <- j
        dif[3, m] <- abs(p[i] - p[j])
        dif[4, m] <- sqrt(qchisq(0.95, df=k-1) * 
                            (p[i]*(1-p[i])/n[i] + p[j]*(1-p[j])/n[j]))
        m <- m + 1    }   }
  dif <- round(dif, 4)
  return(dif)
}
hair <- matrix(c(32, 43, 16, 9, 55, 65, 64, 16), nrow=2, byrow=T)
x <- hair[1,]; n <- colSums(hair)
t <- marascuilo.procedure(x, n)
colnames(t) <- c("black-brown","black-blonde","black-red",
                   "brown-blonde","brown-red","blonde-red")
t[3:4, ]

########################################################################

pairwise.prop.test(x, n, p.adjust.method="holm")     # P-values adjusted

########################################################################

                                                       # Section 7.7.8.3
                                                       
                                                 # sample size and power

                                                 # example fair dice
alpha <- 0.05                                    # significance level
quant <- qchisq(alpha, df=5, lower.tail = FALSE)
n   <- 120                                       # number of throws
pi0 <- rep(1/6, 6)                               # pi under H0
pi1 <- c(rep(3/20, 5), 1/4)                      # pi under HA
effect <- sum((pi1-pi0)^2/pi0)
l <- n * effect; l                               # noncentrality param.
power <- pchisq(quant, df=5, ncp=l, lower.tail=FALSE); power

########################################################################
                                              
lrange <- seq(6, 20, by=0.01); i <- 0            # lambda range
while (power < 0.80) {
	i <- i+1; power <- pchisq(quant, df=5, ncp=lrange[i], lower.tail=FALSE) }
round(power, 4)                                  # power over 80%
nc <- lrange[i] / effect; nc                     # sample size	

########################################################################

                                                         # Section 7.7.9

tabtrend <- function(tab, scores, transpose=FALSE) { # Cochran-Armitage test
    if (any(dim(tab)==2)) {if (transpose==TRUE) {tab <- t(tab)}
    if (dim(tab)[1]!=2) 
            {stop("Cochran-Armitage nur in (2,k)-Tafel", call.=FALSE)}                  
    nidot <- apply(tab,2,sum);   n     <- sum(nidot) # sums and scores
    scri  <- scores;             scrq  <- sum(scri*nidot)/n
    p.i   <- tab[1,] / nidot                         # observede
    p     <- sum(tab[1,])/n
    chi   <- 1/(p*(1-p))*(sum(nidot*((p.i-p)^2)))    # chi-squared total
    b     <- sum(nidot*(p.i-p)*(scri-scrq))/sum(nidot*(scri-scrq)^2)
    pi.h  <- p + b*(scri-scrq)
    chi.e <- (1/(p*(1-p)))*sum(nidot*(p.i-pi.h)^2)   # deviation
    chi.t <- b^2/(p*(1-p))*sum(nidot*(scri-scrq)^2)  # trend   
    z     <- sqrt(chi.t)     
    p     <- 2*pnorm(abs(z), lower.tail=FALSE)       # P-value two-sided
cat(name="Cochran-Armitage Test auf Trend","\n",
    "Chi-squared trend :", chi.trend=round(chi.t, 3)," p =", p.wert=p, "\n",
    "Chi-squared error :", chi.err=round(chi.e, 3),"\n",
    "Chi-squared total :", chi.gesamt=round(chi,3),"\n")
}}

########################################################################

                                           # example alcohol consumption
malform <- matrix(c(48, 38, 5, 1, 1, 17066, 14464, 788, 126, 37), 
          nrow=2, byrow=T,
          dimnames = list(Malformation=c("yes","no"),
          Alcohol=c("0","<1","1-2","3-5",">5")));  malform    
tabtrend(malform, c(0,0.5,1.5,4,7), transpose=FALSE)

########################################################################

x <- malform[1,]; n <- malform[1,]+malform[2,] 
prop.trend.test(x, n, c(0, 0.5, 1.5, 4, 7))

########################################################################

                                                        # Section 7.7.10

                             # comparison of proportions with a standard
                    
ind <- function(d, dir="greater") {                 # indicator function
       n <- length(d); s.p <- rep(NA, n); s.n <- rep(NA, n)
       for (i in 1:n) {
            if (d[i]>0) s.p[i]<-1 else s.p[i]<- 0
            if (d[i]<0) s.n[i]<-1 else s.n[i]<- 0 }
       if (dir=="greater") result <- s.p else 
          if (dir=="less") result <- s.n else NA
       result
       }
prop.ref.test <- function(p.0, x, n, alternative="two-sided") {
    k <- length(x)
    if (alternative=="two-sided") {                         # two-sided
        B <- sum((x - n*p.0)^2/(n*p.0*(1-p.0))) 
        p.val <- pchisq(B, df=k, lower.tail = FALSE)              
        cat("B (two-sided) =",B,", ( P =",round(p.val,8),")\n")} 
    else if (alternative=="greater") {               # one-sided greater 
        diff <- x - n*p.0
        B.plus <- sum((diff*ind(diff, "greater"))^2/(n*p.0*(1-p.0)))                                    
        theta <- pbinom(round(n*p.0), n, prob=p.0, lower.tail = FALSE)
        pv1   <- dbinom(1:k, k, prob=theta)
        pv2   <- pchisq(B.plus, df=1:k, lower.tail = FALSE)
        p.val <- sum(pv1*pv2)
        cat("B (one-sided greater) =",B.plus,", (P =",round(p.val,8),")\n")}
    else if (alternative=="less") {                 # one-sided less
        diff <- x - n*p.0
        B.min <- sum((diff*ind(diff, "less"))^2/(n*p.0*(1-p.0)))                                    
        theta <- pbinom(round(n*p.0), n, prob=p.0, lower.tail = TRUE)
        pv1   <- dbinom(1:k, k, prob=theta)
        pv2   <- pchisq(B.min, df=1:k, lower.tail = FALSE)
        p.val <- sum(pv1*pv2)
        cat("B (one-sided less than) =",B.min,", ( P =",round(p.val,8),")\n")}
}

p.0 <- 0.60                                            
x <- c(59, 107, 48); n <- c(81, 151, 114)  
prop.ref.test(p.0, x, n, alternative="two-sided")

p.0 <- 0.60                                             
x <- c(107, 48);  n <- c(151, 114)  
prop.ref.test(p.0, x, n, alternative="greater")

########################################################################

                                                        # Section 7.7.11

                                                   #  contingency tables

                                             # example therapy successes
success <- matrix(c(14, 22, 32, 18, 16, 8, 8, 2, 0), nr=3, byrow=T,
          dimnames = list(heilung=c("healed-x","healed-x+y","died"),
          therapie=c("symptomatic","spezific N1","spezific N2")))
addmargins(success)
chisq.test(success, correct = TRUE)

chisq.test(success, simulate.p.value = TRUE, B = 1000)

########################################################################
                                                    
n        <- sum(success)                            # residuals adjusted
expected <- outer(rowSums(success), colSums(success), FUN="*")/n
expected <- round(expected, 2); expected
residual <- success - expected; residual
p        <- outer(1-rowSums(success)/n, 1-colSums(success)/n, FUN="*")
adjust   <- residual / sqrt(expected * p); round(adjust, 4)
stat     <- sum(residual^2/expected); stat

########################################################################
 
                                                        # Section 7.7.11

V.Cramer <- function(tab) {             # Cramer contingency coefficient
  n     <- sum(tab)
  nrows <- rowSums(tab); r <- length(nrows)
  ncols <- colSums(tab); c <- length(ncols);   sum   <- 0
  for (i in 1:r) { 
    for (j in 1:c) sum <- sum + tab[i,j]^2 / (nrows[i]*ncols[j]) }
  stat <- n * (sum - 1); stat; pval <- 1- pchisq(stat, df=(r-1)*(c-1))
  V <- sqrt(stat / (n * min((r-1), c-1)))
  cat(" Chi-squared =", stat, ", DF =", (r-1)*(c-1), ",P-value =",pval,"\n",
  "Contingency coefficient according to Cramer V: =", V, "\n")
}
                                            # example preferred car type
cartyp <- matrix(c( 5, 40, 50, 5, 15,  5,  7, 23), nrow=2, 
                 ncol=4, byrow=TRUE,
                 dimnames=list(job=c("Worker","Employee"), 
                typ=c("Convertible","Coupe","Station wagon","SUV")))
addmargins(cartyp)
V.Cramer(cartyp)

chisq.test(cartyp)

########################################################################

                                                        # Section 7.7.11

                                                 # sample size and power
npow.chisq <- function(w=NULL, n=NULL, r=NULL, c=NULL, alpha=NULL, power=NULL) {
    nu <- (r-1)*(c-1)
    quant   <- qchisq(alpha, df=nu, lower=FALSE)
    p.expr  <- quote(pchisq(quant, df=nu, ncp = n * w^2, lower=FALSE))
    if (is.null(power)) power <- eval(p.expr)
    if (is.null(n)) 
      n <- uniroot(function(n) eval(p.expr)-power, c(1e-10, 1e+3))$root
    cat("\n","Sample size and power for the chi-squared test:","\n",
        "Effect index (w).....:",w,"\n",
        "Degrees of freedom...:",nu,"\n",
        "Significance level...:",alpha,"\n",
        "Sample size n (total):",ceiling(n),"\n",
        "Power............... :",power,"\n")
}
npow.chisq(w=0.3, r=2, c=3, alpha=0.05, power=0.80)

npow.chisq(w=0.3, r=2, c=3, alpha=0.05, n=108)

#######################################################################

library(pwr)
pwr.chisq.test(w=0.3 , df=(2-1)*(3-1), sig.level=0.05, power=0.80)

########################################################################

                                                        # Section 7.7.12
                                                          
bowker.test <- function(tab, k) {                       # Bowker test     
    stat <- 0
    for (j in 1:(k-1)) {
        for (i in (j+1):k) { 
    stat <- stat + ((tab[i,j] - tab[j,i])^2 / (tab[i,j] + tab[j,i]))
                     }     } 
    pval <- pchisq(stat, df=k*(k-1)/2, lower.tail = FALSE)
    cat("Test statistic:",stat,"(P-value:",pval,")","\n")   }
k <- 4
tab <- matrix(c(15,4,6,1, 16,10,3,1, 10,2,4,4, 0,4,12,8),nrow=k,byrow=T); tab           
bowker.test(tab, k)

########################################################################

                                                        # Section 7.7.13
                                           
lehmacher.test <- function(tab, k) {                    # Lehmacher test  
    stat <- rep(NA, k)
    r.sum <- apply(tab, 1, sum); c.sum <- apply(tab, 2, sum)
    for (i in 1:k) stat[i] <- (r.sum[i] - c.sum[i])^2 / 
                    (r.sum[i] + c.sum[i] - 2*tab[i,i])  
    p.val <- round(pchisq(stat, df=1, lower.tail = FALSE), 6)
    p.cor <- round(p.adjust(p.val, "hochberg"), 6)
    cat("Test statistic:",round(stat, 4),"\n",
        "P-value.......:",round(p.val,4),"\n",
        "P-value adj...:",round(p.cor, 4),"\n")   } 
wahl <- matrix(c(400,40,20,10, 50,300,60,20, 10,40,120,5, 5,90,50,80), 
    nrow=4, byrow=T, dimnames = 
    list(c("Party A", "Party B","Party C","Party D"),
         c("Party A", "Party B","Party C","Party D"))); wahl
lehmacher.test(wahl, 4)

bowker.test(wahl, 4)

########################################################################

                                                        # Section 7.7.14

stuart.maxwell.test <- function(tab) {             # Stuart-Maxwell test
    if(nrow(tab)!=3 | ncol(tab)!=3) {      # check dimension of tab
        print("Dimension der Tabelle nicht 3*3"); break }
    rs <- rowSums(tab); cs <- colSums(tab)
    d1 <- rs[1] - cs[1]                    # marginal differences
    d2 <- rs[2] - cs[2]
    d3 <- rs[3] - cs[3]
    n12 <- (tab[1,2] + tab[2,1])/2         # symmetry fields
    n13 <- (tab[1,3] + tab[3,1])/2
    n23 <- (tab[2,3] + tab[3,2])/2
    stat <- (n23*d1^2+n13*d2^2+n12*d3^2)/(2*(n12*n13+n12*n23+n13*n23))    
    pval <- pchisq(stat, df=2, lower.tail = FALSE)
    cat("Test statistic:",stat,"(P-value:",pval,")","\n")   }
tab <- matrix(c(35,5,0,  15,20,5,  10,5,5), nrow=3, byrow=T); addmargins(tab)           
stuart.maxwell.test(tab)  

########################################################################

library(irr)
stuart.maxwell.mh(tab)

library(coin)
mh_test(as.table(tab), distribution=approximate(B=9999))

########################################################################

                                                        # Section 7.7.15
                                                    
cochranq.test <- function(mat) {           # Q-test according to Cochran
  k <- ncol(mat);             C <- sum(colSums(mat)^2);   
  R <- sum(rowSums(mat)^2);   T <- sum(rowSums(mat)) 
  Q <- (k - 1)*((k*C) - (T^2)) / (k*T - R)
  df <- k - 1;   names(df) <- "DF";   names(Q) <- "Cochran's Q"
  p.val <- pchisq(Q, df, lower = FALSE)
  QVAL <- list(statistic = Q, parameter = df, p.value = p.val,
               method = "Cochran's Q test for dependent samples",
               data.name = deparse(substitute(mat)))
  class(QVAL) <- "htest";   return(QVAL) }
Wine <- as.table(matrix(c(1,0,1,1,0, 1,1,1,0,1, 0,0,1,1,1, 1,0,1,0,0, 
                       0,0,0,1,1, 1,0,1,1,0), byrow=TRUE, ncol=5,
     dimnames = list("Person"=c("1","2","3","4","5","6"),
                     "Wine" = c("A","B","C","D","E"))))
cochranq.test(Wine)


########################################################################

                                                        # Section 7.7.16
                                                      
library(vcd)                                            # Cohen's kappa 
attention <- matrix(c(14, 3, 5, 18), nrow=2, ncol=2, byrow=TRUE)
attention
Kappa(attention)
confint(Kappa(attention))

########################################################################

library(psy); library(boot)
b1 <- c(rep(0,17), rep(1,23)); b2 <- c(rep(0,14), 
                            rep(1,3), rep(0,5), rep(1,18))
attention <- as.data.frame(cbind(b1, b2))
ckappa(attention)$kappa
ckappa.boot <- function(data, x) {ckappa(data[x,])[[2]]}
res  <- boot(attention, ckappa.boot, 500)
boot.ci(res, type="bca")              

########################################################################
                                                      
                                                        # weighted kappa   
botulin <- matrix(c(5,2,0,1,0, 1,7,2,2,0, 1,2,10,5,1,  
                    0,0,3,4,0, 0,0,0,0,3), 
                    nrow=5, ncol=5, byrow=TRUE); botulin
library(vcd)
Kappa(botulin, weights = "Fleiss-Cohen")
confint(Kappa(botulin, weights = "Fleiss-Cohen"))

########################################################################
                                                      
                                                     # Multi-rater kappa 
radiol <- matrix(c(1,4,0,  2,0,3,   0,0,5,   4,0,1,    3,0,2,
                   1,4,0,  5,0,0,   0,4,1,   1,0,4,    3,0,2),
                   nrow=10, ncol=3, byrow=TRUE)
n     <- 10; R <- 5; k <- 3;
p.i   <- rep(NA, n); 
for (i in 1:n) p.i[i] <- sum(radiol[i,]*(radiol[i,]-1))/(R*(R-1))
p.bar <- sum(p.i)/n; p.bar
p.j   <- rep(NA, k); for (j in 1:k) p.j[j] <- sum(radiol[,j])/(n*R)
p.e   <- sum(p.j^2); p.e
kappa.m <- (p.bar - p.e)/(1-p.e); kappa.m      
var <- (2/(n*R*(R-1))) * (p.e-(2*R-3)*p.e^2+2*(R-2)*sum(p.j^3))/(1-p.e)^2; var
z   <- kappa.m / sqrt(var); z
2*pnorm(z, lower.tail=FALSE)                  

########################################################################

library(irr)
data <- matrix(c(1,2,2,2,2, 1,1,3,3,3, 3,3,3,3,3, 1,1,1,1,3, 1,1,1,3,3,
                 1,2,2,2,2, 1,1,1,1,1, 2,2,2,2,3, 1,3,3,3,3, 1,1,1,3,3),
                 nrow=10, byrow=T,
  dimnames=list(Image=1:10, Examiner=c("U1","U2","U3","U4","U5"))); data
kappam.fleiss(data, exact = FALSE, detail = FALSE)

########################################################################

                                                        # Section 7.7.17

                                                  # Krippendorff's alpha
o1 <- c(1,  2, 3, 3, 2,  1, 4, 1, 2, NA, NA, NA)
o2 <- c(1,  2, 3, 3, 2,  2, 4, 1, 2,  5, NA,  3)
o3 <- c(NA, 3, 3, 3, 2,  3, 4, 2, 2,  5,  1, NA)
o4 <- c(1,  2, 3, 3, 2,  4, 4, 1, 2,  5,  1, NA)
dat <- rbind(Obs_A=o1, Obs_B=o2, Obs_C=o3, Obs_D=o4)
library(irr)
kripp.alpha(dat, method="ordinal")


########################################################################

                                                        # Section 7.7.18

library(irr)                         # Kendall's concordance coefficient
ranking <- matrix(c(3,1,4,6,5,7,8,2,
                    2,3,5,7,4,6,8,1,
                    3,2,5,4,6,8,7,1), nrow=3, byrow=T)
kendall(t(ranking), correct=TRUE)

# pchisq(18.77, 7, ncp=0, lower.tail = F, log.p = FALSE)

########################################################################

                                                           # Section 7.8
                                                         
                                            # correlation and regression

########################################################################

x <- c( 4 , 6 , 8 , 3 , 9 , 5 , 10 , 2 , 7 , 8)
y <- c( 5 , 5 , 7 , 4 , 11 , 7 , 9 , 5 , 8 , 10)
n <- length(x)
r <- cor(x,y, method="pearson"); r
t_hat <- r * sqrt((n-2)/(1-r^2)); t_hat
cor.test(x, y, method="pearson")

########################################################################
                 
                                                 # Fisher transformation

                                                            # table 7.81
r <- seq(0, 0.99, 0.01); zp <- function(r) 0.5*log((1+r)/(1-r))     
tab <- matrix(round(zp(r),4), byrow=T, nrow=10);  tab[1:10,]

                                                            # table 7.82
z <- seq(0, 3, 0.01); zr <- function(z) (exp(2*z)-1)/(exp(2*z)+1)   
tab <- matrix(round(zr(z), 4), byrow=T, ncol=10); tab[1:10, ]

########################################################################

                                                       # Section 7.8.1.2

                                  # correlation in multiple measurements
daten <- read.csv("bland_cor.csv", sep = ";", dec = ",")
subj <- 1:4
attach(daten)

cor.test(y, x)                    # Pearson correlation all observations
tmp  <- by(daten, id, function(d) cor(d$y, d$x))
korr <- tmp[1:4]; round(korr,3)   # Pearson correlation individual cases

tmp.y <- by(daten, id, function(d) mean(d$y))      # means for each case
tmp.x <- by(daten, id, function(d) mean(d$x))
tmp.n <- by(daten, id, function(d) length(d$x))
cor.test(tmp.y, tmp.x)            # Pearson correlation from averages

########################################################################

mx <- round(tmp.x, 2); my <- round(tmp.y, 2); w  <- tmp.n
korr.w <- (sum(w*mx*my) - sum(w*mx)*sum(w*my) / sum(w)) / 
    sqrt( (sum(w*mx^2) - (sum(w*mx)^2/sum(w))) *
              (sum(w*my^2) - (sum(w*my)^2/sum(w))) )
korr.w          # Pearson correlation weighted correlation within cases


vartab <- summary(aov(y ~ as.factor(id) + x, data=daten)); vartab
saq    <- as.vector(vartab[[1]][2])
korr.w <- sqrt(saq[[1]][2] / (saq[[1]][2]+saq[[1]][3])); korr.w

########################################################################

                                                           # figure 7.33
par(mfcol=c(1,2), lwd=1.5, font.axis=1.5, bty="l", ps=15) 
plot(x[id==subj[1]], y[id==subj[1]], las=1,
     xlab="X", ylab="Y", xlim=c(35, 75),    ylim=c(35, 75), 
     xaxp=c(35, 75, 8), yaxp=c(35, 75, 8), cex=1.6, pch=1)
for (i in 2:4) points(x[id==subj[i]], y[id==subj[i]], cex=1.6, pch=i)
abline(h=seq(35, 75, 5), lty=2, col="grey")
text(70,73,"A", cex=2)
points(tmp.x, tmp.y, pch=16, cex=1.6)   
abline(lm(tmp.y ~ tmp.x), lty=1, lwd=1.7)

plot(x[id==subj[1]], y[id==subj[1]], las=1,
     xlab="X", ylab="Y", xlim=c(35, 75),    ylim=c(35, 75), 
     xaxp=c(35, 75, 8), yaxp=c(35, 75, 8), cex=1.5, pch=1)
for (i in 2:4) points(x[id==subj[i]], y[id==subj[i]], cex=1.6, pch=i)
abline(h=seq(35, 75, 5), lty=2, col="grey")
                                     
tmp  <- with(daten, by(daten, id, function(d) lm(y ~ x, data = d)))
regr <- sapply(tmp, coef)
for (i in 1:4) abline(a=regr[1,i], b=regr[2,i], lty=1, lwd=1.7)
text(70,73,"B", cex=2)


########################################################################

                                                       # Section 7.8.1.3
                        
                                                 # sample size and power
npwr.rho <- function(n=NULL, r, sig.lev=0.05, power=NULL) {
  if (sum(sapply(list(n, power), is.null)) != 1) 
    stop("only n or power can be missing")                             
  z.alpha <- qnorm(1-sig.lev/2)              # hypotheses only two-sided 
  if (is.null(n))         {
    z.beta  <- qnorm(power)
    n <- ((z.alpha + z.beta)/atanh(r))^2 + 3
    return(ceiling(n))   }
  if (is.null(power))       {
    z.beta <- sqrt(n-3)*atanh(r) - z.alpha
    power <- pnorm(z.beta)
    return(round(power, 4)) } }
                                                     
rho <- seq(0.1, 0.9, by=0.1)                                # table 7.83
pwr <- seq(0.5, 0.9, by=0.1)
tab <- matrix(rep(0, 5*9), byrow=T, nrow=9)
for (i in 1:5) tab[,i] <- npwr.rho(r=rho, power=pwr[i], sig.lev=0.05)
tab1 <- tab
for (i in 1:5) tab[,i] <- npwr.rho(r=rho, power=pwr[i], sig.lev=0.01)
cbind(tab1,tab)

########################################################################

npwr.rho(r=0.60, power=0.90)

library(pwr)
prp <- pwr.r.test(n=NULL, r=0.60, power=0.90, alternative="two.sided")
prp

plot(prp)                                                  # figure 7.34

########################################################################

                                                         # Section 7.8.2

                                                      # rank correlation

library(SuppDists)                                          # table 7.84                             
                                               # upper limits, one-sided
alpha <- c(0.005, 0.025, 0.05);  q <- 1 - alpha
n     <- 4:30

q.Kendall <- matrix(NA, nrow=27, ncol=3)
q.Spearm  <- matrix(NA, nrow=27, ncol=3)

for (i in 4:30) {
  for(j in 1:3) {
    q.Kendall[i-3, j] <- qKendall(q[j], n[i-3], lower.tail=TRUE)
    q.Spearm[i-3, j]  <- qSpearman(q[j], n[i-3], lower.tail=TRUE)
  } }
tab <- cbind(n, round(q.Spearm, 3), round(q.Kendall, 3), n)
tab

########################################################################

                                                         # Section 7.8.3
x <- c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
y <- c(2, 1, 5, 3, 4, 6, 7, 9, 8, 10)
# cor.test(x, y, method="spearman")
cor.test(x, y, method="kendall")

########################################################################

                                                       # Section 7.8.4.1

xi <- c(1, 5, 9, 13);  k <- length(xi)               # testing linearity  
ni <- c(2, 3, 1,  2);  n <- sum(ni)
yij <- matrix(c(1,2,NA, 2,3,3, 4,NA,NA, 5,6,NA), ncol=k, byrow=FALSE)
yisum <- rep(0, k)                       # group means       
for (j in 1:k) {for (i in 1:ni[j]) yisum[j] <- yisum[j] + yij[i,j]}
yibar <- yisum / ni
                                         # linear regression (x, y)
x <- NULL; for (j in 1:k) x <- c(x, rep(xi[j], ni[j]))
y <- NULL; for (j in 1:k) {for (i in 1:ni[j]) y <- c(y, yij[i,j])}
linreg <- lm(y~x); a <- linreg$coeff[1]; b <- linreg$coeff[2]
yihat    <- a + b*xi                     # estimate  
ZF <- (1/(k-2))*sum(ni*(yibar-yihat)^2)  # residuals   
sn <- 0                              
for (j in 1:k) {for (i in 1:ni[j]) sn <- sn + (yij[i,j] - yibar[j])^2}
NF <- (1/(n-k))*sn
F  <- ZF/NF; F                           # test statistic F

########################################################################

                                                       # Section 7.8.4.2
                                                         
chow.test <- function(x, y, gruppe)  {  # Chow test for structural break
  n  <- length(x); k <- 2
  if (length(y) != n | length(gruppe) != n) 
    stop("unterschiedliche Laengen in 'x', 'y' oder 'gruppe' ")
  x1 <- x[gruppe==1]; x2 <- x[gruppe==2]
  y1 <- y[gruppe==1]; y2 <- y[gruppe==2] 
  ur.reg <- lm(y ~ x)                  # linear regression moel lm() 
  r.reg1 <- lm(y1 ~ x1);  r.reg2 <- lm(y2 ~ x2)  
  SSR = NULL                           # squared residuals 
  SSR$ur <- ur.reg$residuals^2; sum(SSR$ur)
  SSR$r1 <- r.reg1$residuals^2; sum(SSR$r1)
  SSR$r2 <- r.reg2$residuals^2; sum(SSR$r2) 
  zaehler <- (sum(SSR$ur) - (sum(SSR$r1) + sum(SSR$r2))) / k
  nenner  <- (sum(SSR$r1) +  sum(SSR$r2)) / (n - 2*k)
  chow    <- zaehler / nenner;   P <- 1 - pf(chow, k, (n - 2*k))
  cat(sep="","\n","Chow test: F=",chow," with ",k,";",n-2*k,
      " degrees of freedom (P-value=",P,")","\n")   }
x <- c(1.6, 2.0, 2.7, 3.0, 3.5, 4.0, 4.5, 5.2, 5.5, 6.0, 6.5, 7.0)
y <- c(2.1, 2.0, 1.9, 2.6, 2.8, 3.3, 3.5, 4.5, 6.5, 6.9, 7.8, 8.2)
grp <- c(rep(1, 7), rep(2, 5))
chow.test(x, y, grp)

########################################################################

                                                           # figure 7.35
n   <- length(x); cut <- 5; ol <- 8
groups <- c(rep(1, cut), rep(2, n-cut))
dfr <- as.data.frame(cbind(x,y,groups))

ur.reg <- lm(y ~ x, data = dfr)                # regression (total)
r.reg1 <- lm(y ~ x, data = dfr[1:cut,])        # restricted to  1:19
r.reg2 <- lm(y ~ x, data = dfr[cut+1:n,])      # restricted to 20:38                   

par(mfcol=c(1,1),lwd=2, font.axis=2, bty="n", ps=15)  
plot(x, y, xlim=c(1,ol), ylim=range(y), las=1, cex=1.5)  
abline(v=cut, lwd=3, lty=3)
abline(ur.reg, col = "red", lwd = 2, lty = "dashed")    # total
segments(0, r.reg1$coefficients[1], cut,                # part 1 / 2
   r.reg1$coefficients[1] + cut * r.reg1$coefficients[2], col= 'blue')
segments(cut, r.reg2$coefficients[1] + cut * r.reg2$coefficients[2],
   ol, r.reg2$coefficients[1] + ol * r.reg2$coefficients[2], col= 'blue')

########################################################################

                                                       # Section 7.8.4.3

                                    # Durbin-Watson test autocorrelation
x <- c( 96,104, 96,108,105,107, 98,102, 99, 96,101,
        107,114, 94, 82,111, 93,100, 98, 90)
y <- c(201,209,204,217,203,203,184,202,201,186,200,
        224,246,199,181,237,197,217,219,199)
n <- length(x)
                                                           # figure 7.37
mod <- lm(y~x); e <- residuals(mod);                
par(mfcol=c(1,3), lwd=2, font.axis=2, bty="l", ps=15) 
plot(x, y, las=1, xlab="x", ylab="y", cex=1.4, pch=16, col="black")
abline(mod, lty=3, col="black")
plot(1:n, e, type="b", las=1, xlab="Umpteenth measurement", ylab="Residual")
abline(h=0, lty=2, col="black")
acorr <- acf(e, lag.max=5, main=" ", ylab="Autocorrelation coefficients")

########################################################################                
                                                    
mod <- lm(y~x); e <- residuals(mod)                 # Durbin-Watson test
d   <- rep(NA, n-1)
for (i in 2:n) d[i-1] <- (e[i] - e[i-1])
dw_stat <- sum(d^2)/sum(e^2); dw_stat
library(lmtest)
dwtest(mod)

########################################################################
                                                    # correction of data
lag_e <- rep(NA, n-1); lag_y <- rep(NA,n-1); lag_x <- rep(NA, n-1)
for (i in 2:n) {lag_e[i] <- e[i-1];   
                lag_y[i] <- y[i-1];   
                lag_x[i] <- x[i-1] }
mc  <- lm(e ~ lag_e - 1)                  
rho <- mc$coefficients; rho                # autocorrelation coefficient
y_c <- y - rho*lag_y;   x_c <- x - rho*lag_x
modc<- lm(y_c ~ x_c); summary(modc)


########################################################################
#########################################################################
